//
// C++ Interface: kbibremotesearchdlg
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KBIBREMOTESEARCHDLG_H
#define KBIBREMOTESEARCHDLG_H

#include "kbibpreview.h"
#include "searchmanager.h"

#include <kdialogbase.h>
#include <kcombobox.h>
#include <klistview.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kurllabel.h>
#include <kstatusbar.h>
#include <ktextedit.h>
#include <qcheckbox.h>
#include <qtabwidget.h>

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class KBibRemoteSearchDlg : public KDialogBase
{
Q_OBJECT
public:
    KBibRemoteSearchDlg(QWidget *parent = 0, const char *name = 0);
	~KBibRemoteSearchDlg();
	public:
		void stop();
	private slots:
		void slotSourceSelected(const QString&);
		void slotSearchClick();
		void slotAddEntryClick();	
		void slotAddAllEntryClick();
		void slotClearClick();
		void slotEntryClicked(QListViewItem *);
		void slotEntryDoubleClicked(QListViewItem *);
		void slotSelectionChanged();
		void slotResultFound(BibEntry*);
		void slotQueryResult(unsigned int);
		void slotMessage(QString, int );
		void slotSearchDone();
	protected:
		virtual void keyPressEvent ( QKeyEvent *e );
private:
	QTabWidget* queryTab;
	KComboBox* dataSource;
	KComboBox* searchKey1, *searchKey2, *searchKey3;
	KComboBox* operator1, *operator2;
	KLineEdit* searchTerms1, *searchTerms2, *searchTerms3;
	KTextEdit* queryStringEdit;
	KPushButton* searchButton;
	KListView* listView;
	KTextEdit* entryPreview;
	QCheckBox* ignoreExistingSelect;
	QCheckBox* createKeySelect;
	KPushButton* addButton;
	KPushButton* addAllButton;
	KPushButton* clearButton;
	KURLLabel* querySyntaxURLLab; 
	
//	searchManager *m_manager;
	
	bool m_started;
};

#endif
