//
// C++ Interface: kbibgroupview
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KBIBGROUPVIEW_H
#define KBIBGROUPVIEW_H

#include <kpopupmenu.h>
#include <klistview.h>
#include <qdict.h>
#include <qstring.h>
#include "kbibgroupviewgroup.h"
#include "bibentrytable.h"
#include "kbibpreview.h"

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class KBibGroupView : public KListView
{
Q_OBJECT
public:
    KBibGroupView(QWidget *parent = 0, const char *name = 0, QString key="Author");

    ~KBibGroupView();
	void addBibEntryTable(BibentryTable *table) { m_list = table; createGroupView(); }
	void setGroupBy(QString st) { groupBy = st; }
	void createGroupView();
	void addEntry(BibEntry *entry);
	QString currentGroupBy() {return groupBy; }
	void addPreview(KBibPreview *preview) { p_preview = preview; }
	void clearGroupView(void) {m_groupDict.clear(); }
	BibentryTable * getBibEntryTable()  { return m_list; }
//	void addGroup(entryGroup *group);
	
private slots:
	void slotRMB(QListViewItem *, const QPoint& point, int col);
		void slotItemSelect(QListViewItem *);	
		void slotSelectionChanged(QListViewItem *);	
		void slotItemDoubleClicked(QListViewItem *);
		void slotCollape();
		void slotExpand();
		void slotNewItem();
		void slotEditEntry();
		void slotHandleDelete();
		void slotCut();
		void slotCopy();
		void slotPaste();
		void slotLockKey();
		void slotUnlockKey();
		void slotCiteEntry();
		void slotViewURL();
		void slotViewFile();
private:
	BibentryTable * m_list;	
	KBibPreview * p_preview;		
	QDict<KBibGroupViewGroup> m_groupDict;
	QString groupBy;
	KPopupMenu* popupMenu;
	KPopupMenu* m_itemMenu;
};

#endif
