/***************************************************************************
                          kbibfinddlg.cpp  -  description
                             -------------------
    begin                : Sat Aug 9 2003
    copyright            : (C) 2003 by Thach Nguyen
    email                : thach.nguyen@rmit.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbibfinddlg.h"
#include "kbib.h"

#include "kbibdoc.h"

#include <iostream>

#include <klocale.h>
#include <kmessagebox.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qstringlist.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qregexp.h>
#include <qwhatsthis.h>


KBibFindDlg::KBibFindDlg(QWidget *parent, const char *name)
                :KDialogBase(parent, name, false, i18n("Find Text"), User1|Cancel, User1,
                             false, i18n("&Find"))
{

        QWidget* page = new QWidget(this);
        setMainWidget(page);

        QVBoxLayout* topLayout = new QVBoxLayout(page, 0, KDialog::spacingHint());

        topLayout->addWidget(new QLabel(i18n("Text To Find:"), page));

        m_pattern = new KHistoryCombo(true, page);
        QWhatsThis::add
                (m_pattern, i18n("The search string"));
        m_pattern->setMinimumWidth(fontMetrics().maxWidth()*15);
        m_pattern->setMaxCount(10);
        m_pattern->setDuplicatesEnabled(false);
        topLayout->addWidget(m_pattern);

        connect(m_pattern, SIGNAL(activated(const QString&)),
                m_pattern, SLOT(addToHistory(const QString&)));

        connect(m_pattern, SIGNAL(textChanged(const QString&)),
                this, SLOT(slotPatternChanged(const QString&)));

        topLayout->addWidget(new QLabel(i18n("Search In:"), page));

        m_attributes = new KComboBox(page);
        QWhatsThis::add
                (m_attributes, i18n("Select which field should be searched."));
        updateAttributeList();
        topLayout->addWidget(m_attributes);

        QGroupBox* optionsGroup = new QGroupBox(2, Qt::Horizontal, i18n("Options"), page);
        optionsGroup->layout()->setSpacing(KDialog::spacingHint());
        topLayout->addWidget(optionsGroup);

        m_caseSensitive = new QCheckBox(i18n("Case &Sensitive"), optionsGroup);
        QWhatsThis::add
                (m_caseSensitive, i18n("If checked, the search is case-sensitive."));
        //  m_findBackwards = new QCheckBox(i18n("Find &Backwards"), optionsGroup);
        //  QWhatsThis::add(m_findBackwards, i18n("If checked, the document is searched in reverse."));
        //  m_wholeWords = new QCheckBox(i18n("&Whole Words Only"), optionsGroup);
        //  QWhatsThis::add(m_wholeWords, i18n("If checked, the search is limited to whole words."));
        m_fromBeginning = new QCheckBox(i18n("&From Beginning"), optionsGroup);
        QWhatsThis::add
                (m_fromBeginning, i18n("If checked, the document is searched from the beginning."));
        //  m_asRegExp = new QCheckBox(i18n("As &Regular Expression"), optionsGroup);
        //  QWhatsThis::add(m_asRegExp, i18n("If checked, the search string is used as a regular expression."));

        /*  if(!KTrader::self()->query(QString::fromLatin1("KRegExpEditor/KRegExpEditor")).isEmpty()) {
            m_editRegExp = new KPushButton(i18n("&Edit Regular Expression..."), optionsGroup);
            m_editRegExp->setEnabled(false);
            connect(m_asRegExp, SIGNAL(toggled(bool)), m_editRegExp, SLOT(setEnabled(bool)));
            connect(m_editRegExp, SIGNAL(clicked()), this, SLOT(slotEditRegExp()));
          }
        */
        topLayout->addStretch(1);

        m_pattern->setFocus();
        enableButton(User1, false);

        startIndex = 0;

}

void KBibFindDlg::updateAttributeList()
{
        m_attributes->clear();

        m_attributes->insertItem(i18n("All Fields"));
        m_attributes->insertItem("citation key");
		m_attributes->insertStringList(BibEntryDefTable::self()->getFieldNames());
		
        m_attributes->adjustSize();

}


KBibFindDlg::~KBibFindDlg()
{}


void KBibFindDlg::slotPatternChanged(const QString& text_)
{
        enableButton(User1, !text_.isEmpty());
}
/** No descriptions */
void KBibFindDlg::slotUser1()
{
        QString text = m_pattern->currentText();
        m_pattern->addToHistory(text);

        int att = (m_attributes->currentItem())-1;
        int options = 0;
        //  KMessageBox::information (this, "To be implemented");

        KBibApp *win=(KBibApp *) parent();
        KBibDoc *m_doc = win->getDocument();

        if (m_fromBeginning->isChecked()) {
                startIndex = 0;
                m_fromBeginning->setChecked(false);
        }

        if (m_caseSensitive->isChecked())
                options = options|1;
        /*  if (m_findBackwards->isChecked())
            options = options|2;
        */

        int found = m_doc->search_string(const_cast<char* >(text.ascii()), startIndex, att, options);

        if (startIndex!=0 && found==-1) {
                if(KMessageBox::questionYesNo(this, i18n("End of document reached.\nContinue from beginning?"), i18n("Find") ) == KMessageBox::No) {
                        this->reject();
                        startIndex = 0;
                } else {
                        startIndex = 0;
                        slotFindNext();
                }
        }

        else if (startIndex == 0 && found==-1) {
                this->reject();
                KMessageBox::information(this, i18n("No entry is found!"), i18n("Find") );
        }
        else
                startIndex = found+1;

}

/** No descriptions */
void KBibFindDlg::slotFindNext()
{
        slotUser1();
}
