//
// C++ Interface: kbibexporthtmldlg
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KBIBEXPORTHTMLDLG_H
#define KBIBEXPORTHTMLDLG_H

#include <kdialogbase.h>

#include <klineedit.h>
#include <kpushbutton.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <kcombobox.h>
#include <qvgroupbox.h>
#include <qbuttongroup.h> 
#include <qradiobutton.h>


/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class KBibExportHTMLDlg : public KDialogBase
{
Q_OBJECT
public:
    KBibExportHTMLDlg(QWidget *parent = 0, const char *name = 0);

    ~KBibExportHTMLDlg();
	QString getBibStyle(void) { return bibStyle->currentText() ; }
	bool isIncludeAbstract(void) { return includeAbstract->isChecked(); }
	bool isIncludeKeywords(void) { return includeKeywords->isChecked(); }
	bool isOpenFile(void) { return openFile->isChecked(); }
	bool isRevertOrder(void) { return revertOrder->isChecked(); }
	int getSortBy();
private:
	KPushButton *browseBttn;
	KComboBox  *bibStyle;
	QCheckBox *includeAbstract;
	QCheckBox *includeKeywords;
	QVGroupBox *groupBox;
	QButtonGroup *buttonGroup;
	QRadioButton *byDate;
	QRadioButton *byAuthor;
	QRadioButton *unsort;
	QCheckBox *revertOrder;
	QCheckBox *openFile;
	public slots:
		void slotBrowseBttn();

};

#endif
