/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "kbfxconfig.h"


//Note: these are some things for kbfx 0.5. later Akh and I shall merge these with new kcontrol module


KbfxConfig::KbfxConfig()
{
//TODO
read();
}


KbfxConfig& ConfigInit()
{
	static KbfxConfig _config;
	return _config;
}


void KbfxConfig::read()
{

 KConfigSkeleton *confskel= new KConfigSkeleton( QString::fromLatin1( "kbfxrc" ));

 KConfig * conf = confskel->config();
 QString __default  = KGlobal::iconLoader()->iconPath("kbfx",(int)KIcon::Desktop,false);
 conf->setGroup("KbfxButton");
        KIconLoader *iconload = KGlobal::iconLoader ();
        QString path = iconload->iconPath (QString ("normal"), KIcon::Desktop, false);
	path.remove("normal.png");
	
	m_KbfxNormalButtonPath = conf->readEntry  ("Normal",path+"/normal.png");
 	m_KbfxHoverButtonPath = conf->readEntry   ("Hover",path+"/hover.png");
 	m_KbfxPressedButtonPath = conf->readEntry ("Press",path+"/pressed.png");
	m_KbfxMenuType = conf->readEntry("MenuType","spinx");
 conf->setGroup("SpinxBar");
	path.remove("actions");
	path.remove("48x48");
	path.remove("crystalsvg");
	path.remove("icons");
	path.remove("////");
	m_SpinxThemeBasePath = conf->readEntry("ThemePath",path+"apps/kbfx/skins/");	
	m_SpinxDudeBlink  = conf->readBoolEntry("DudeBlink",false);	
	m_SpinxThemeName  = conf->readEntry("ThemeName","");	
 conf->setGroup("ToolTip");
	m_ToolTipAnimation = conf->readBoolEntry("AnimatedTooltip",true);
	m_ToolTipText      = conf->readEntry("ToolTipText","Application Menu");
//get butterly
        iconload = KGlobal::iconLoader ();
        path = iconload->iconPath (QString ("butterfly"), KIcon::Desktop, false);
	m_ToolTipAvatar    = conf->readEntry("ToolTipAvatar",path);
  conf->setGroup("runtime");
        m_KbfxHistory = conf->readEntry("History","");		
	
}


void KbfxConfig::write()
{
 KConfigSkeleton    *confskel= new KConfigSkeleton( QString::fromLatin1( "kbfxrc" ));
    // write general options
    KConfig * conf = confskel->config();
  conf->setGroup("KDE Action Restrictions");
    conf->writeEntry("warn_unwritable_config",false);


  conf->setGroup("KbfxButton");
    conf->writeEntry("Normal", m_KbfxNormalButtonPath);
    conf->writeEntry("Hover",m_KbfxHoverButtonPath);
    conf->writeEntry("Press",  m_KbfxPressedButtonPath);
    conf->writeEntry("MenuType",m_KbfxMenuType);
 conf->setGroup("SpinxBar");
    conf->writeEntry("ThemePath",m_SpinxThemeBasePath);
    conf->writeEntry("DudeBlink",m_SpinxDudeBlink); 
    conf->writeEntry("ThemeName",m_SpinxThemeName); 
   
  conf->setGroup("ToolTip");
    
    conf->writeEntry("AnimatedTooltip",m_ToolTipAnimation);
    conf->writeEntry("ToolTipText",m_ToolTipText);
    conf->writeEntry("ToolTipAvatar",m_ToolTipAvatar);
    
   conf->setGroup("runtime");
    conf->writeEntry("History",m_KbfxHistory);
    conf->sync();
}

void KbfxConfig::setNormalButtonPath(QString path)
{
if(!path.isNull())
m_KbfxNormalButtonPath = path;
}

void KbfxConfig::setHoverButtonPath(QString path)
{
if(!path.isNull())
m_KbfxHoverButtonPath = path;
}

void KbfxConfig::setPressedButtonPath(QString path)
{
if(!path.isNull())
	m_KbfxHoverButtonPath = path;
}

