/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef KBFXCONFIG_H
#define KBFXCONFIG_H

#include <qstring.h>
#include <qfont.h>
#include <qcolor.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kconfigskeleton.h>

class KbfxConfig 
{
public:

void setHoverButtonPath(QString _path);
void setNormalButtonPath(QString _path);
void setPressedButtonPath(QString _path);

void read();

void write();


/*-----------------*/
	//list of Config items for kbfx_menu_button

	QString m_KbfxNormalButtonPath;
	QString m_KbfxHoverButtonPath;
	QString m_KbfxPressedButtonPath;
	QString m_KbfxMouseOverAnimationPath;
	QColor  m_KbfxButtonColor;
	int 	m_KbfxButtonSize;
	bool	m_KbfxButtonGlow;
	bool 	m_KbfxButtonKikerResize;
	QString m_KbfxMenuType;
/*------------------*/
	//list of Config Items for Spinx
	QString m_SpinxThemeBasePath;	
	bool m_SpinxDudeBlink;
	QString m_SpinxThemeName;
/*-------------------*/
	//list of tooltip options
       bool     m_ToolTipAnimation;
       QString  m_ToolTipText;
       QString  m_ToolTipAvatar;
	
       QString  m_KbfxHistory;

	
private:
	KbfxConfig();
	KbfxConfig(const KbfxConfig&);

friend KbfxConfig& ConfigInit();

};

KbfxConfig & ConfigInit();

#endif

