%define name	kbfx
%define version	0.4.9.2
%define is_cvs	1

%if %{is_cvs}
%define kbfx_release 20060611cvs
%else
%define kbfx_release 1
%endif

%define is_unknown %(test -e /etc/mandrake-release -o -e /etc/SuSE-release -o -e /etc/fedora-release && echo 0 || echo 1)
%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)
%define is_fedora %(test -e /etc/fedora-release && echo 1 || echo 0)
%define is_mandrake %(test -e /etc/mandrake-release && echo 1 || echo 0)

%if %{is_suse}
%define prefix	/opt/kde3
Group:		System/GUI/KDE
Release:	%{kbfx_release}.suse%(echo "%{suse_version}" | %__sed -e 's/.$//')
Requires:	kdelibs3
BuildRequires:	kdelibs3-devel kdebase3-devel
BuildRequires:	autoconf, automake, libtool
BuildRequires:	glibc-devel, libstdc++-devel
%endif

%if %{is_fedora}
%define fedora_version      %(rpm -q --queryformat '%{VERSION}' fedora-release)
%define fedora_vernum       %(echo "%{fedora_version}" | tr -d '.')
%define prefix	/usr
Group:		System/GUI/KDE
Release:	%{kbfx_release}.FC%{fedora_vernum}
Requires:	kdebase
BuildRequires:	kdebase-devel
BuildRequires:	autoconf, automake, libtool
BuildRequires:	glibc-devel, libstdc++-devel
%endif

%if %{is_mandrake}
%define prefix	/usr
Group:		Graphical desktop/KDE
Release:	%{kbfx_release}.mdk%(echo "%{mdkversion}" | %__sed -e 's/.$//')
Requires:	kdebase, libkdebase4
BuildRequires:	autoconf, automake, libtool
BuildRequires:	libkdebase4-devel, glibc-devel, libstdc++-devel
%endif

%if %{is_unknown}
%define prefix	%(kde-config --prefix)
Group:		Graphical desktop/KDE
Release:	%{kbfx_release}
BuildRequires:	autoconf, automake, libtool
%endif

%if %{is_cvs}
Source:		%{name}-%{kbfx_release}.tar.gz
%else
Source:		%{name}-%{version}.tar.gz
%endif

Name:		%{name}
Version:	%{version}
License:	GPL
URL:		http://www.kbfx.org
Summary:	An alternative to the classical K-Menu button and it's menu.
BuildRoot:	%{_tmppath}/build-%{name}-%{version}-root
Packager:	PhobosK <phobosk@mail.kbfx.org>
Vendor:		KBFX TEAM
Provides:	kbfx

%description
KBFX is an alternative to the classical K-Menu button and it's menu.
It improves the user experience by enabling the user to set a bigger (and thus more visible) start button and by finally replacing the Win95-like K-Menu with the Spinx bar.
If you still want the old menu, because you're used to it, it is still available as an option in kbfx.

Main features:
 Spinx Bar has 6 Basic Functionalities.
 1.Selecting an Application Group
 2.Selecting an Application
 3.Type and locate an Application
 4.Logout of the Desktop
 5.Lock the Desktop
 6.Launch KBFX settings manager
 7.Scroll up and down the application list

Extra features:
 1.Double buffered Widgets to minimize flicker.
 2.Animated scroll bars
 3.New Tooltip
 4.Gif/Mng File Support
 5.New Control Manager

%prep

%if %{is_cvs}
%setup -n %{name}-%{kbfx_release}
%else
%setup
%endif

./autogen.sh
./configure --prefix=%{prefix}

%build
%if %{is_suse}
. /etc/opt/kde3/common_options
make -e %{?jobs:-j%{jobs}}
%else
make
%endif


%install
[ "${RPM_BUILD_ROOT}" != "/" ] && [ -d ${RPM_BUILD_ROOT} ] && rm -Rf ${RPM_BUILD_ROOT};
make prefix=${RPM_BUILD_ROOT}%{prefix} install

mkdir -p ${RPM_BUILD_ROOT}%{_menudir}
cat << EOF > ${RPM_BUILD_ROOT}%{_menudir}/%{name}
?package(%{name}): needs="kde" kde_filename="kcmkbfx" \
section="System/Configuration/KDE/LookNFeel" title="KBFX SPINX Applet" icon="kcmkbfxnew" \
command="kcmshell kcmkbfx" longtitle="KBFX SPINX - a kcontrol module" \
kde_opt="\\\\nEncoding=UTF-8\\\\nX-KDE-Library=kcmkbfx\\\\nX-KDE-ParentApp=kcontrol\\\\nType=Application\\\\nX-KDE-ModuleType=Library\\\\nX-KDE-HasReadOnlyMode=false\\\\nKeywords=kbfx,kbfx"
?package(%{name}): needs="kde" kde_filename="kbfxconfig" \
section="System/Configuration/Other" title="KBFX SPINX Configure" icon="kcmkbfxnew" \
command="kbfxconfigapp" longtitle="KBFX SPINX - configuration module" \
kde_opt="\\\\nEncoding=UTF-8\\\\nType=Application"
EOF

%post
if [ -x /usr/bin/update-menus ]; then /usr/bin/update-menus || true ; fi
/sbin/ldconfig

%postun
if [ "$1" = "0" -a -x /usr/bin/update-menus ]; then /usr/bin/update-menus || true ; fi
/sbin/ldconfig


%clean
[ "${RPM_BUILD_ROOT}" != "/" ] && [ -d ${RPM_BUILD_ROOT} ] && rm -Rf ${RPM_BUILD_ROOT};

%files
%defattr(-, root, root)
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README TODO HOWTO LICENSE KNOWN_BUGS
%{prefix}/*
%{_menudir}/*

%changelog

* Sun May 28 2006 0.4.9.2-20060611cvs
 - ADDED KNOWN_BUGS file in the project documents
 - ADDED PC-BSD Support
 - ADDED Drag and Drop Support
 - FIXED a bug with showing icons in "Recently Used" items
 - FIXED a bug with the placement of ".face.icon" (thanks @Nucc)
 - Flicker Free KBFX Button
 - Flicker Free KBFX SPINX Menu TOP
 - Better scrolling 


* Sun May 28 2006 0.4.9.2-20060528cvs
 - ADDED suport for Fedora rpm
 - ADDED an option to disable tooltip (see HOWTO file)
 - FIXED a problem with building SUSE rpm


* Wed May 10 2006 0.4.9.2rc1
 - ADDED suport for SUSE rpm
 - ADDED support for Buttons with Drop shadows
 - ADDED Font settings as part of the Theme itself
 - ADDED Grouping header for each application group and sub groups
 - ADDED Kiosk mode support
 - ADDED Handling of submenus
 - FIXED a problem with make
 - FIXED make system for all distributions
 - Better support for Mandriva distribution
 - More applications for the menu


* Sun Apr 16 2006 0.4.9.1-1
 Initial rpm release
 - FIXED Kbfx configuration 
 - FIXED Slack 1.9 automake and compilation 
 - FIXED /tmp/.kbfx.html

