/***************************************************************************
                          kbearfilesyspart.h  -  description
                             -------------------
    begin                : Tue Feb 12 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARFILESYSPART_H
#define KBEARFILESYSPART_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
#include <qvaluelist.h>
#include <qptrstack.h>
#include <qptrlist.h>
#include <qmap.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kaction.h>
#include <kfileitem.h>
#include <kfileview.h>
#include <kfile.h>
#include <kdeversion.h>
#include <kparts/event.h>
#include <kparts/browserextension.h>
#include <kaboutdata.h>
#include <kurldrag.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "../../base/kbearchildviewpart.h"

class KBearDirLister;
class KBearDirView;
class KFileView;
class KParts::ReadOnlyPart;
class QDateTime;
class QListViewItem;
class KComboBox;
class KHistoryCombo;
class QSplitter;
class QLabel;
class QTextCodec;


/**
  *@author Bjrn Sahlstrm
  */

class KBearFileSysPart : public KBearChildViewPart  {
   Q_OBJECT
public: 
	/** */
	KBearFileSysPart( QWidget* parentWidget, const char* widgetName,
						QObject* parent, const char* name, const QStringList& lst=QStringList() );
	/** */
	static KAboutData* createAboutData();
	/** */
	virtual ~KBearFileSysPart();
	/** */
	virtual KURL::List selectedURLs();
	/** */
	virtual KURL currentDir();
	/** */
	virtual void readProperties( KConfig* config, const QString& group );
	/** */
	virtual void saveProperties( KConfig* config, const QString& group );
	/** */
	virtual QPopupMenu* popupMenu();
	/** */
	virtual void openConnection( const Connection& c );
	/** */
	virtual bool disconnect();
	/** */
	virtual Connection connection() const { return m_connection; }
public slots:
	/** */
	virtual void reload();
	/** */
	virtual void home();
	/** */
	virtual void cdUp();
	/** */
	virtual void back();
	/** */
	virtual void forward();
	/** */
	virtual void stop();
	/**  */
	virtual bool openURL( const KURL& url );
protected:
	virtual void guiActivateEvent( KParts::GUIActivateEvent* event );
private slots:
	/** */
	void slotEnableGUI( const QString& , bool );
	/** */
	void slotSynch();
	/** */
	void slotClearSynch();
	/** */
	void updateSynchList();
	/** */
	void slotSynch(const QString& localPath, const QString& remotePath );
	/** */
	void slotNewSynch();
	/** */
	void slotGotPreviewPart( KParts::ReadOnlyPart*, const KURL& realURL );
	/** */
	void slotSetupViewMenu();
	/** */
	void slotClipboardDataChanged();
	/** */
	void slotDeleteFinished();
	/** */
	void slotConnectResult( int ERR );
	/** */
	void slotInfoMessage( const QString& );
	/** */
	void slotInfoMessage( KIO::Job*, const QString& );
	/** */
	void slotPathActivated( int item );
	/** */
	void slotSelectionChanged();
	/** */
	void activatedMenu( const KFileItem *, const QPoint& pos );
	/**  */
	void showFileView();
	/**  */
	void slotStatusMessage( const QString&);
	/**
	*Copy the selected file(s) to the clipboard
	*/
	void slotCopy();
	/**
	*Cut the selected file(s) to the clipboard
	*/
	void slotCut();
	/**
	* Paste the file contents from the clipboard into current path
	*/
	void slotPaste();
	/**  */
	void slotFind();
	/**  */
	void slotClearSelection();
	/**  */
	void slotSelectAll();
	/**  */
	void slotInvertSelection();
	/** No descriptions */
	void slotOpenWith();
	/** No descriptions */
	void slotOpen();
	/** No descriptions */
	void slotOpenWithService(int);
	/**   */
	virtual void slotFinishedLoading();
	/**  */
	virtual void slotStartLoading();
	/**  */
	void slotToggleHidden( bool );
	void slotToggleTreeView( bool );
	void slotSortByName();
	void slotSortBySize();
	void slotSortByDate();
	void slotSortReversed();
	void slotToggleDirsFirst();
	void slotToggleIgnoreCase();
	/** */
	void slotClearStatusBar();
 	/** */
	void reconnect();
	/** */
	void slotSetupPopupMenu();
	void slotShowProgress();
	/**  */
	void slotProgress( int percent );
	/**  */
	void slotProgress( KIO::Job*, unsigned long percent );
	/** Deletes the currently selected files/directories. */
	void slotDelete();
	/** Deletes the currently selected files/directories in a way that make them unrecoverable. */
	void slotShred();
	void resetCursor();
	void slotUpdateDirsAndFiles( int dirs, int files );
	void slotNewItems(const KFileItemList &newone);
	void slotDetailedView();
	void slotSimpleView();
	void slotOpenFile( const KFileItem* item );
	void slotFileSelected( const KFileItem* item );
	void slotOpenDir( const KFileItem* item );
	void slotDirSelected( const KFileItem* item );
	void slotUpdateTime();
	void slotViewActionAdded( KAction * );
	void slotViewActionRemoved( KAction * );
	void slotViewSortingChanged( QDir::SortSpec sort );
	void slotDeleteItem( KFileItem *item );
	void slotJobStarted( KIO::Job* );
	void slotProperties();
	void mkdir();
	void slotFilterChanged(const QString&);
	void slotSpeed( int speed );
	void slotSpeed( KIO::Job*, unsigned long );
	void slotClear();
	void slotRedirected( const KURL& newURL );
	void slotConnected();
	void slotSetWindowCaption( const QString& );
private:
	void enableGUI( bool );
	void cleanUpPartViewer();
	void connectDirlister();
	void setActionsEnabled( bool );
	void addToPathHistory(const QString& path );
	void clearHistory();
	void addToHistory(const KURL& url );
	void pathChanged();
	void updateSortActions();
	/**  */
	void setDir( const KURL& url );
	/**  */
	void deleteFiles( const KFileItemList* items, bool shred );
	/**  */
	int setupOpenWithMenu();
	/**  */
	void doCutCopy( bool cut );
    /**
     * Sets the way to sort files and directories.
     */
    void setSorting( QDir::SortSpec );
    /**
     * Updates the view-related actions to comply with the current
     * KFile::FileView
     */
    void updateViewActions();
    /**
     * A view factory for creating predefined fileviews.
     */
     KFileView* createView( QWidget* parent, KFile::FileView view );
   /**
     * Sets one of the predefined fileviews
     * @see KFile::FileView
     */
    void setView(KFile::FileView view );
	/** */
	void setup();
	/** */
	void setupActions();
	/** */
	void connectView(KFileView* );
    /**
     * @returns true if we are displaying the root directory of the current url
     */
    bool isRoot() const { return m_url.path() == QChar('/'); }
private:
    /**
     * Contains all URLs you can reach with the back button.
     */
    QPtrStack<KURL> m_backStack;

    /**
     * Contains all URLs you can reach with the forward button.
     */
    QPtrStack<KURL> m_forwardStack;

    QDir::SortSpec m_mySorting;
    KFileView *m_fileView;

    // the enum KFile::FileView as an int
    int m_currentViewKind;

    KProgress* m_progress;

    QTimer* m_progressDelayTimer;

	QPtrList<KAction> m_serviceActionList;
	KBearDirView* m_leftView;
	QSplitter* m_splitter;
	QDateTime m_myTime;
	KComboBox* m_pathCombo;
	KHistoryCombo* m_filterCombo;
	QLabel* m_speedLabel;
	QLabel* m_directoryLabel;
	QLabel* m_fileLabel;
	QLabel* m_endLabel;
	int m_numOfConnRetry;
	int m_connRetryTime;
	KURL m_lastURL;
	QWidget* m_partViewerWidget;
	bool m_isConnected;

	KActionCollection* m_privateActionCollection;
	KActionMenu *actionMenu;

	KAction 	*backAction;
	KAction 	*forwardAction;
	KAction 	*homeAction;
	KAction 	*upAction;
	KAction 	*reloadAction;
	KAction 	*stopAction;
	KAction 	*deleteAction;
	KAction 	*shredAction;
	KActionSeparator *actionSeparator;
	KAction 	*mkdirAction;

	KActionMenu *sortActionMenu;
	KRadioAction *byNameAction;
	KRadioAction *byDateAction;
	KRadioAction *bySizeAction;
	KToggleAction *reverseAction;
	KToggleAction *dirsFirstAction;
	KToggleAction *caseInsensitiveAction;

	KActionMenu *viewActionMenu;
	KRadioAction *shortAction;
	KRadioAction *detailedAction;
	KToggleAction *treeAction;
	KToggleAction *showHiddenAction;

	KActionMenu* openWithMenu;
	KActionCollection* m_viewActionCollection;
	bool m_isLoading;
	QValueList<int> m_splitterSizes;
	QTextCodec* m_codec;
	bool m_guiEnabled;;
};
#endif
