/***************************************************************************
                          dirsynchtreebranch.h  -  description
                             -------------------
    begin                : lr okt 19 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DIRSYNCHTREEBRANCH_H
#define DIRSYNCHTREEBRANCH_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qptrlist.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kfiletreebranch.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "../../base/kbeardirlister.h"

class KFileTreeViewitem;

/**
  *@author Bjrn Sahlstrm
  */

class DirSynchTreeBranch : public KFileTreeBranch  {
	Q_OBJECT
public: 
	/** */
	DirSynchTreeBranch( KFileTreeView*, const KURL& url, const QString& name,
                    const QPixmap& pix, bool showHidden = false );
	/** */
	virtual ~DirSynchTreeBranch();
	/** */
	void setDirLister( KBearDirLister* d );
	/** */
	virtual bool openURL( const KURL& url, bool _keep = false, bool _reload = false );
	/** */
	virtual KFileTreeViewItem* findTVIByURL( const KURL& );
	/** */
	void setColors( const QColor& diff, const QColor& mRemote, const QColor& mLocal );
	/** */
	void setTimeDiff( int );
	/** */
	const QColor diffColor() const { return m_diffColor; }
	/** */
	const QColor missingRemoteColor() const { return m_missingRemoteColor; }
	/** */
	const QColor missingLocalColor() const { return m_missingLocalColor; }
public slots:
	virtual bool populate( const KURL &url, KFileTreeViewItem* currItem );
signals:
	/** */
	void finishedLoading( KFileTreeBranch* );
protected:
	/** */
	virtual  KFileTreeViewItem* createTreeViewItem( KFileTreeViewItem* parent, KFileItem* fileItem ) ;
private slots:
	void slotPopulateFinished( KFileTreeViewItem* currItem );
private:
	KBearDirLister* m_dirLister;
	QPtrList<KFileTreeViewItem> m_pendingList;
	QColor m_diffColor;
	QColor m_missingRemoteColor;
	QColor m_missingLocalColor;
	int m_timeDiff;
};

#endif
