/***************************************************************************
                          kbearpart.h  -  description
                             -------------------
    begin                : mn okt 14 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARPART_H
#define KBEARPART_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kparts/part.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "connection.h"

class KURL;
class KBearDirLister;

/**
  *@author Bjrn Sahlstrm
  */

class KBearPart : public KParts::ReadOnlyPart  {
	Q_OBJECT
public:
	/** */
	KBearPart( QWidget* parentWidget, const char* widgetName, QObject* parent, const char* name);
	/** */
	virtual ~KBearPart();
	/** */
	virtual void openConnection( const Connection& ) = 0;
	/** */
	void setDirLister( KBearDirLister* lister ) { m_dirLister = lister; }
public slots:
	/**  */
	virtual bool openURL( const KURL& url ) = 0;
signals:
	/** */
	void logMessage( const QString& );
	/**  */
	void closeMe();
protected:
	QString normalizeLabel( const QString& lbl );
protected:
	KBearDirLister* m_dirLister;
	Connection m_connection;
};

#endif
