/***************************************************************************
                          kbeardirlister.h  -  description
                             -------------------
    begin                : fre mar 8 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARDIRLISTER_H
#define KBEARDIRLISTER_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
#include <qptrlist.h>
#include <qregexp.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kparts/part.h>
#include <kfileitem.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "connection.h"

class KDirLister;
class KBearListJob;

/**
  *@author Bjrn Sahlstrm
  */

class KBearDirLister : public QObject  {
	Q_OBJECT
public: 
	/** */
	KBearDirLister( QObject* parent, const char* name, const Connection& c );
	/** */
	virtual ~KBearDirLister();
	/** */
	KURL url() const { return m_url; }
	/** */
	Connection connection() const { return m_connection; }
	/** */
	void openURL( const KURL& url, bool reload = false );
	/** */
	void statURL( const KURL& url );
	/** */
	void setShowingDotFiles( bool );
	/** */
	bool showingDotFiles() const { return m_showingDotFiles; }
	/** */
	void stop();
	/** */
	void setNameFilter(const QString& filter);
	/** */
	void mkdir( const KURL& url );
	/** */
	bool isLocal() const { return m_isLocal; }
	/** */
	KIO::Job* deleteFiles( const KURL::List, bool shred, bool showProgress );
	/** */
	void getPreviewPart( const KURL&, QWidget* );
	/** */
	bool isConnected() const { return ( m_state & CONNECTED ); }
public slots:
	/** */
	void openConnection();
	/** */
	void slotDisconnectSlaveInfo();
	/** */
	void slotInfoMessage( KIO::Job*, const QString& message );
signals:
	/** */
	void previewPart( KParts::ReadOnlyPart*, const KURL& realURL );
	/** */
	void started();
	/** */
	void started( const KURL& );
	/** */
	void connected();	
	/** */
	void deleteFinished();	
	/** */
	void finishedLoading();	
	/** */
	void progress( int );
	/** */
	void progress( KIO::Job*, unsigned long);
	/** */
	void speed( int );	
	/** */
	void newItems( const KFileItemList& );
	/** */
	void deleteItem( KFileItem* );	
	/** */
	void openDir( const KFileItem* );	
	/** */
	void openFile( const KFileItem* );	
	/** */
	void redirection( const KURL& );
	/** */
	void redirection( const KURL&,const KURL& );
	/** */
	void completed( const KURL& );
	/** */
	void clear();	
	/** */
	void reload();	
	/** */
	void infoMessage( const QString&);	
	/** */
	void gotError( int );	
private slots:
	void statLink();
	void slotStatRedirection( KIO::Job*, const KURL& url );
	void slotResult( KIO::Job* );
	void slotNewItems( const KFileItemList& items );
	void slotEntries( KIO::Job*, const KIO::UDSEntryList& entryList );
	void slotPercent( KIO::Job*, unsigned long pcnt );
	void slotSpeed( KIO::Job*, unsigned long speed );
	void slotRedirection( KIO::Job*, const KURL& url );
	void slotRedirection( const KURL& oldurl, const KURL& newurl );
	void slotSlaveError( int, const QString& );
	void slotSlaveConnected();
//	void slotMimeResult( KIO::Job* job );
	void slotMimeType( KIO::Job*, const QString& mime );
//	void slotPendingList();
//	void slotPendingStat();
//	void slotPendingPreview();
	void slotSlaveDied();
	void slotSlaveKilled( KIO::Slave* );
private:
	void getPreviewMode();
	void listRemoteDir( const KURL& );
	void determineMimetype();
	void setDirLister();
	bool matchesNameFilter( const QString& name ) const;
	KParts::ReadOnlyPart* getPreviewPartInternal();
private:
	/** this enum specify different states for the dirlister
     	these states can be OR:ed together but is usually used separate
	*/
	enum State {
		DISCONNECTED = 1,
		CONNECTING = 2,
		CONNECTED = 4,
		LISTING = 8,
		STATING = 16,
		GETTING_PREVIEW = 32,
		GETTING_MIME = 64,
		MAKING_DIR = 128,
		DELETING = 256,
		STATING_LINK = 512
	};
	KURL m_statURL;
	KURL m_statLinkURL;
	KURL m_url;
	KURL m_previewURL;
	KDirLister* m_dirLister;
	KIO::Slave* m_slave;
	KBearListJob* m_listJob;
	KIO::StatJob* m_statJob;
	Connection m_connection;
	bool m_useFilter;
	QPtrList<QRegExp> m_filterList;
	bool m_isLocal;
	bool m_showingDotFiles;
	KParts::ReadOnlyPart* m_partViewer;
	QWidget* m_partViewerWidget;
	QString m_mime;
	QString m_previewConnect;
	/** this keeps track of the current state */
	unsigned int m_state;
	unsigned int m_viewMode;
	KURL* m_tempFile;
};

#endif
