/***************************************************************************
                          csvfile.h  -  description
                             -------------------
    begin                : Mon Mar 28 2005
    copyright            : (C) 2005 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "csvfile.h"

#include "printersettings.h"

#include <qbuffer.h>
#include <qtextcodec.h>

CSVFile::CSVFile( const QString & filename )
{
    m_eof = false;

    m_lpdata = PrinterSettings::getInstance()->getData();

    m_file.setName( filename );
    m_file.open( IO_ReadOnly );

    if( m_file.isOpen() )
	m_stream.setDevice( &m_file );
}

CSVFile::CSVFile( QBuffer & buf )
{
    m_eof = false;

    m_lpdata = PrinterSettings::getInstance()->getData();

    buf.open( IO_ReadOnly );

    if( buf.isOpen() )
	m_stream.setDevice( &buf );
}

CSVFile::~CSVFile()
{
    if( m_stream.device() && m_stream.device()->isOpen() )
	m_stream.device()->close();
}

QStringList CSVFile::readNextLine()
{
    QStringList sections;
    QString line;
    unsigned int start   = 0;
    unsigned int end     = 0;
    unsigned int len;
    bool quoted          = false;
    bool quote_empty;

    if( !m_stream.device() )
	return sections;

    if( !m_stream.device()->isOpen() )
	return sections;

    // walk through the lines until a line containing valid data
    for( ;; )
    {
	line = m_stream.readLine();
	line = line.stripWhiteSpace();

	// check for eof
	if( line.isNull() )
	{
	    m_eof = true;
	    return sections;
	}
	
	// ignore comments and empty lines
	if( (!m_lpdata->comment.isEmpty() && line.startsWith( m_lpdata->comment )) || line.isEmpty() ) 
	    continue;

	break;
    }

    // if line does not end with separator, add one
    if( !line.endsWith( m_lpdata->separator ) )
	line.append( m_lpdata->separator );

    // we have to handle here the case, 
    // that the separator is included 
    // in a quoted field
    len = line.length(); // cache for better speed
    quote_empty = m_lpdata->quote.isEmpty();
    while( end < len )
    {
        if( !quote_empty && line.right( len - end ).startsWith( m_lpdata->quote ) ) 
            quoted = !quoted;
        else if( !quoted && line.right( len - end ).startsWith( m_lpdata->separator ) ) 
        {
            sections << removeQuote( line.mid( start, end-start ) );

            start = end;
            ++start;
        }
        else if( line[end] == '\n' )
            break;
        
        ++end;
    }

    return sections;
}

QString CSVFile::removeQuote( const QString & text ) 
{
    QString line = text.stripWhiteSpace();

    if( m_lpdata->quote.isEmpty() )
        return text;

    if( line.startsWith( m_lpdata->quote ) )
	line = line.right( line.length() - m_lpdata->quote.length() );

    if( line.endsWith( m_lpdata->quote ) )
	line = line.left( line.length() - m_lpdata->quote.length() );

    return line;
}

void CSVFile::setEncoding( const QString & enc )
{
    m_stream.setCodec( QTextCodec::codecForName( enc.latin1() ) );
}

