/***************************************************************************
                          labeleditor.h  -  description
                             -------------------
    begin                : Die Apr 23 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LABELEDITOR_H
#define LABELEDITOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sqltables.h"
#include "labelutils.h"
#include "definition.h"
#include "dsmainwindow.h"
#include "xmlutils.h"

#include <kdialogbase.h>
#include <qdialog.h>
#include <qmap.h>

class KURL;
class KAction;
class KActionMenu;
class KActionSeparator;
class KToggleAction;
class KRecentFilesAction;
class KToolBarPopupAction;
class KListBox;
class KMenuBar;
class KPopupMenu;
class KRuler;
class KToolBar;
class KCommandHistory;
class MyCanvasText;
class MyCanvasRectangle;
class MyCanvasView;
class CanvasBarcode;
class MyCanvas;
class QCanvasItem;
class QCanvasItemList;
class QCheckBox;
class KComboBox;
class QDockArea;
class QDockWindow;
class QGroupBox;
class QLabel;
class QImage;
class QHBoxLayout;
class QVBoxLayout;
class QPoint;
class QRect;
class QPaintDevice;
class QString;
class KPushButton;
class KPrinter;
/** The LabelEditor is a graphical, easy to use label designer.
  * It provides all the function necessary to create colorful labels
  * and save them. Labels can also be printed directly, but without database
  * support. Use Batchprinting (LabelPrinter) for this.
  */
class LabelEditor : public DSMainWindow, private LabelUtils, private XMLUtils {
    Q_OBJECT
    public:
        enum _mode {
            CreateNewLabel,
            LoadLabel
        };

        LabelEditor( QWidget *parent=0, QString _filename = QString::null,
            const char *name="labeleditor", WFlags f = WType_TopLevel | WDestructiveClose );
        ~LabelEditor();
        bool startupDlg( int mode, QString f = QString::null );

        /**
          * returns the filename of the currently loaded label.
          */
        const QString fileName() const;
        
    private:
        QString getCustomerName( int mode = 0, QString text = "" );
        void clearLabel();
        void setupBarcode( CanvasBarcode* bcode );
        void insertText( QString caption );
        void setupActions();
        void enableActions();
        bool isChanged();   // if the current document has been changed

    private slots:
        void startEditor();
        bool load();
        bool load( QString name );
        bool save();
        bool saveas();
        bool save( QString name );
        bool newLabel();
        void print();
        void insertBarcode();
        void insertPicture();
        void insertPicture( QImage* img );
        void insertText();
        void insertDataText( int index );
        void insertRect();
        void insertCircle();
        void insertLine();
        void insertAddress();
        void exportLabel();

        /** export to the Zebra Printing Language */
        void exportZPL();
        void changeDes();
        void changeSize();
        void updateInfo();
        void doubleClickedItem( QCanvasItem* item );
        void showContextMenu( QCanvasItem* item, QPoint pos );
        void doubleClickedCurrent();
        void changePictureSettings( QCanvasItem* item = 0 );
        void changeText( QCanvasItem* item = 0 );
        void changeRectSettings( QCanvasItem* item = 0 );
        void changeLineSettings( QCanvasItem* item = 0 );
        void spellCheck();
        void centerVertical();
        void centerHorizontal();
        void raiseCurrent();
        void lowerCurrent();
        void onTopCurrent();
        void backCurrent();
        void preview();
        void toggleGrid();
        void moveByValue();
        void cut();
        void copy();
        void paste();
        void startBarcodeGen();
        void saveConfig();
        void loadConfig();
        void startLoadRecentEditor( const KURL& url );
        void startLoadEditor();
        void batchPrint();
        void closeLabel();
        void setEdited();
        void launchAddressBook();

    protected:
        void closeEvent( QCloseEvent* e );

        KCommandHistory* history;

        KAction* saveAct;
        KAction* saveAsAct;
        KAction* exportAct;
        KAction* exportZPLAct;
        KAction* descriptionAct;
        KAction* printAct;
        KAction* changeSizeAct;
        KAction* deleteAct;
        KAction* barcodeAct;
        KAction* rectAct;
        KAction* circleAct;
        KAction* lineAct;
        KAction* pictureAct;
        KAction* previewAct;
        KAction* textAct;
        KAction* spellAct;
        KAction* cutAct;
        KAction* copyAct;
        KAction* pasteAct;
        KAction* undoAct;
        KAction* redoAct;
        KAction* closeLabelAct;
        KAction* addressAct;
        KAction* addressBookAct;

        KPopupMenu* exportMenu;
        KActionMenu* menuFields;
                
        KToolBar* tools;
        
        KToggleAction* gridAct;
        
        KComboBox* comboScale;

        KRecentFilesAction* recentAct;
        KActionSeparator* sep;
        KToolBarPopupAction* listAct;
        MyCanvas* c;
        MyCanvasView* cv;

        Definition* d;
                
        // Label info's:
        QString description;    // description
        QString filename;       // current file

        KListBox* listFields;
        KPushButton* buttonText;

        QVBoxLayout* pageLayout;

        QMap<QString,QString> fields;

        bool m_edited;
};

class BarcodeCombo;
class BarcodeWidget;
class KLineEdit;
class KIntNumInput;
class KColorButton;
class QCheckBox;

/** Change barcode settings from within the labeleditor. The difference
  * to BarCodeDialog is that there is no preview, but SQL Database support.
  *
  * @see BarCodeDialog
  * @author Dominik Seichter
  */
class BarcodeSettingsDlg : public KDialogBase {
    Q_OBJECT

    public:
        BarcodeSettingsDlg( QWidget* parent = 0, const char* name = 0 );
        ~BarcodeSettingsDlg();

        KComboBox* comboComplex;
        BarcodeWidget* barcode;
        
    public slots:
        void changedCombo();
        
    private slots:
        void defaults();
        
    protected:
        QLabel* TextLabel1;

        QVBoxLayout* BarcodeSettingsLayout;
};

class PictureSettings : public KDialogBase {
    Q_OBJECT
    public:
        PictureSettings( QWidget* parent = 0, const char* name = 0 );
        ~PictureSettings() { }

        KIntNumInput* spinRotation;
};

class PositionDialog : public KDialogBase {
    Q_OBJECT
    public:
        PositionDialog( QWidget* parent = 0, const char* name = 0 );
        ~PositionDialog() { }

        KIntNumInput* spinX;
        KIntNumInput* spinY;
};
#endif
