/***************************************************************************
                          kbarcode.cpp  -  description
                             -------------------
    begin                : Mit Jan 15 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbarcode.h"
#include "barcodedialog.h"
#include "labeleditor.h"
#include "labelprinter.h"
#include "databasebrowser.h"
#include "csvimportdlg.h"

// Qt includes
#include <qgroupbox.h>
#include <qlayout.h>

// KDE includes
#include <kaction.h>
#include <kcmdlineargs.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kpushbutton.h>

KBarcode::KBarcode( QWidget *parent, const char *name, WFlags f)
    : DSMainWindow( parent, name, f )
{
    QGroupBox* w = new QGroupBox( this );
    w->setColumnLayout(0, Qt::Vertical );
    QVBoxLayout* layout = new QVBoxLayout( w->layout() );
    setCentralWidget( w );

    buttonSingle = new KPushButton( i18n("Barcode &Generator..."), w );
    buttonSingle->setEnabled( BarCode::haveBarcode() );
    buttonEditor = new KPushButton( i18n("&Label Editor..."), w );
    buttonBatch = new KPushButton( i18n("&Batch Printing..."), w );
    buttonData = new KPushButton( i18n("Edit SQL &Tables..."), w );
    buttonData->setEnabled( false );
    
    buttonSingle->setIconSet( BarIconSet( "barcode" ) );
    buttonEditor->setIconSet( BarIconSet( "edit" ) );
    buttonBatch->setIconSet( BarIconSet( "fileprint" ) );

    layout->addWidget( buttonSingle );
    layout->addWidget( buttonEditor );
    layout->addWidget( buttonBatch );
    layout->addWidget( buttonData );

    connect( buttonSingle, SIGNAL( clicked() ), this, SLOT( startSingle() ) );
    connect( buttonEditor, SIGNAL( clicked() ), this, SLOT( startEditor() ) );
    connect( buttonBatch, SIGNAL( clicked() ), this, SLOT( startBatch() ) );
    connect( SqlTables::getInstance(), SIGNAL( connectedSQL() ), this, SLOT( enableData() ) );
    
    setupActions();
    show();

    KAction* editLabelDefAct = new KAction(i18n("&Edit Label Definitions"), "",
                                0, this, SLOT(editLabelDef()), actionCollection(), "design" );

    KAction* editArticleAct = new KAction(i18n("&Edit Articles"), "",
                                0, this, SLOT(editArticles()), actionCollection(), "design" );

    KAction* editCustomerAct = new KAction(i18n("&Edit Customers"), "",
                                0, this, SLOT(editCustomers()), actionCollection(), "design" );

    KAction* editCustomerTextAct = new KAction(i18n("&Edit Customer Text"), "",
                                0, this, SLOT(editCustomerText()), actionCollection() );

    KAction* importCSVAct = new KAction(i18n("&Import CSV File..."), "",
                                0, this, SLOT(importCSV()), actionCollection() );
                                
    KPopupMenu* data = new KPopupMenu( buttonData );
    editLabelDefAct->plug( data );
    editArticleAct->plug( data );
    editCustomerAct->plug( data );
    editCustomerTextAct->plug( data );
    buttonData->setPopup( data );
    data->insertSeparator();
    importCSVAct->plug( data );

    enableData();
    parseCmdLine();
}

KBarcode::~KBarcode()
{
    DSMainWindow::saveConfig();
}

void KBarcode::setupActions()
{
    DSMainWindow::setupActions();
}

void KBarcode::startSingle()
{
    new BarCodeDialog();
}

void KBarcode::startEditor()
{
    new LabelEditor();
}

void KBarcode::startBatch()
{
    new LabelPrinter( QString::null );
}


void KBarcode::editArticles()
{
    new DatabaseBrowser( TABLE_BASIC, 0, "basicbrowser" );
}

void KBarcode::editCustomers()
{
    new DatabaseBrowser( TABLE_CUSTOMER, 0, "customerbrowser" );
}

void KBarcode::editCustomerText()
{
    new DatabaseBrowser( TABLE_CUSTOMER_TEXT, 0, "customertextbrowser" );
}

void KBarcode::editLabelDef()
{
    new DatabaseBrowser( TABLE_LABEL_DEF, 0, "defbrowser" );
}

void KBarcode::enableData()
{
    buttonData->setEnabled( SqlTables::getInstance()->isConnected() );
}

void KBarcode::parseCmdLine()
{
    KCmdLineArgs* args = KCmdLineArgs::parsedArgs();

    for( int i = 0; i < args->count(); i++)
        new LabelEditor( 0, args->url( i ).path() );

    if( args->isSet("single" ) )
        new BarCodeDialog();

    if( args->isSet("batch") )
        new LabelPrinter( QString::null );

    if( args->isSet( "label" ) )
        new LabelEditor();
        
    QString printer = args->getOption("d");
    QCStringList optlist = args->getOptionList ( "b" );
    for (QCStringList::ConstIterator it=optlist.begin(); it!=optlist.end(); ++it) {
        LabelPrinter pr( *it );
        pr.setCustomerId( args->getOption( "c" ) );
        pr.setLabelURL( args->getOption( "l" ) );
        if( args->isSet( "print" ) )
            pr.print( true, printer );
    }

    args->clear();      // Free some memory
}

void KBarcode::importCSV()
{
    new CSVImportDlg( this, "csvimportdlg" );
}

