/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2007 Kouhei Sutou <kou@cozmixng.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-history-utils.h"

#include "kazehakase.h"
#include "utils.h"

gboolean
kz_history_time_stamp_exists(void)
{
	return g_file_test(KZ_GET_HISTORY_TIME_STAMP, G_FILE_TEST_EXISTS);
}

void
kz_history_make_time_stamp (void)
{
	kz_utils_make_time_stamp(KZ_GET_HISTORY_DIR, KZ_GET_HISTORY_TIME_STAMP);
}

void
kz_history_purge_by_time_stamp(time_t limit_seconds)
{
	kz_utils_purge_files_by_time_stamp(KZ_GET_HISTORY_DIR,
					   KZ_GET_HISTORY_TIME_STAMP,
					   limit_seconds);
}

void
kz_history_append_time_stamp(const gchar *target)
{
	kz_utils_append_time_stamp(target, KZ_GET_HISTORY_TIME_STAMP);
}
