/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004  Hidetaka Iwai
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * The original code is gtk2/bbs_thread_ui.c in ochusha-0.5.7
 * Copyright (c) 2003-2004 The Ochusha Project.
 */

#ifndef __KZ_POPUP_PREVIEW_H__
#define __KZ_POPUP_PREVIEW_H__

#include <gtk/gtk.h>
#include "kz-embed.h"

G_BEGIN_DECLS

#define KZ_TYPE_POPUP_PREVIEW		        (kz_popup_preview_get_type ())
#define KZ_POPUP_PREVIEW(obj)		        (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_POPUP_PREVIEW, KzPopupPreview))
#define KZ_POPUP_PREVIEW_CLASS(klass)	        (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_POPUP_PREVIEW, KzPopupPreviewClass))
#define KZ_IS_POPUP_PREVIEW(obj)	        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_POPUP_PREVIEW))
#define KZ_IS_POPUP_PREVIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_POPUP_PREVIEW))
#define KZ_POPUP_PREVIEW_GET_CLASS(obj)	        (G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_POPUP_PREVIEW, KzPopupPreviewClass))

typedef struct _KzPopupPreview        KzPopupPreview;
typedef struct _KzPopupPreviewClass   KzPopupPreviewClass;

struct _KzPopupPreview
{
	GObject parent;
};

struct _KzPopupPreviewClass
{
	GObjectClass parent_class;
};

GType           kz_popup_preview_get_type      (void) G_GNUC_CONST;
KzPopupPreview* kz_popup_preview_new           (void);
KzPopupPreview* kz_popup_preview_get_instance  (void);

void            kz_popup_preview_start         (KzPopupPreview *popup,
						const gchar* uri,
						const gchar* img,
						gint x, gint y);
void            kz_popup_preview_reset         (KzPopupPreview *popup);

G_END_DECLS

#endif /* __KZ_POPUP_PREVIEW_H__ */
