def move_to_anchor(kz)
  page = kz.current_page
  return unless page
  uri = page.location
  anchors = page.dest_anchors
  index = nil
  anchors.each_with_index do |anchor, i|
    if uri == anchor.link
      index = i
      break
    end
  end
  target_anchor = yield(anchors, index)
  kz.load_url(target_anchor.link) if target_anchor and target_anchor.link
end

def act_move_to_previous_anchor(action, group, kz)
  move_to_anchor(kz) do |anchors, i|
    if i.nil? or i.zero?
      nil
    else
      anchors[i - 1]
    end
  end
end

def act_move_to_next_anchor_config(config, kz)
  config[:label] = N_("Move to previous anchor")
  config[:tooltip] = N_("move to previous anchor")
end

def act_move_to_next_anchor(action, group, kz)
  move_to_anchor(kz) do |anchors, i|
    if i.nil?
      anchors.first
    else
      anchors[i + 1]
    end
  end
end

def act_move_to_next_anchor_config(config, kz)
  config[:label] = N_("Move to next anchor")
  config[:tooltip] = N_("move to next anchor")
end
