#***************************************************************************
# *   Copyright (C) 2003-2006 by A Lynch                                    *
# *   aalynch@users.sourceforge.net                                         *
# *                                                                         *
# *   This program is free software; you can redistribute it and/or modify  *
# *   it under the terms of the GNU General Public License version 2 as published by  *
# *   the Free Software Foundation;                                         *
# *                                                                         *
# *   This program is distributed in the hope that it will be useful,       *
# *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
# *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
# *   GNU General Public License for more details.                          *
# *                                                                         *
# *   You should have received a copy of the GNU General Public License     *
# *   along with this program; if not, write to the                         *
# *   Free Software Foundation, Inc.,                                       *
# *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
# ***************************************************************************/

from PyQt4 import QtGui, QtCore

import sys

import equation
import qt4factory

import logging
l = logging.getLogger(__name__)

class ImageDelegate(QtGui.QAbstractItemDelegate):

    def __init__(self, parentTable):
        QtGui.QAbstractItemDelegate.__init__(self, parentTable)
        self.parentTable = parentTable

    def paint(self, painter, option, index):
        data = self.getData(index)
        if data:
            pixmap = data.pixmap
            x, y = self.parentTable.getLocation(index)
            if pixmap:
                painter.drawPixmap(x + 10, y + 10, pixmap)
            else:
                painter.drawText(x+10, y+10, data.text)

    def sizeHint(self, option, index):
        data = self.getData(index)
        if data.pixmap:
            h = pixmap.height() + 20
            w = pixmap.width() + 20
        else:
            # TODO work out text size
            h = 50
            w = 1000
        return QSize(w, h)
        
    def getData(self, index):
        dataIdVariant = index.model().data(index, QtCore.Qt.UserRole)
        dataId, ok = dataIdVariant.toInt()
        if ok and dataId in equation.DrawObject.drawobjects:
            data = equation.DrawObject.drawobjects[dataId]
            return data
        else:
            return None

    def createEditor(self, parent, option, index):
        l.debug("create editor")
        label = QtGui.QLabel(parent)
        return label
    
    def setEditorData(self, editor, index):
        l.debug("set editor data for index " + repr(index))
        editor.setPixmap(self.getPixmap(index))
        return
            
class EquationTable(QtGui.QTableWidget):
    def __init__(self, control, parent):
        QtGui.QTableWidget.__init__(self, parent)
        self.setItemDelegate(ImageDelegate(self))
        self.control = control


    def getLocation(self, index):
        row = index.row()
        column = index.column()
        item = self.item(row,column)
        vRect = self.visualItemRect(item)
        return vRect.x(), vRect.y()

    def insertRow(self):
        self.setRowCount(self.rowCount()+1)

    def currentText(self):
        text = self.getText(self.currentRow(),self.currentColumn())
        return text

    def getText(self, row, column):
        objectindex = self.data[row][column]
        obj = equation.DrawObject.drawobjects[objectindex]
        return obj.text

    def getObject(self, row, column):
        objectindex = self.data[row][column]
        obj = equation.DrawObject.drawobjects[objectindex]
        return obj

    def showLastRow(self):
        #self.verticalScrollBar().setProperty("sliderPosition",self.verticalScrollBar().property("maximum"))
        #return
        lastRow = self.rowCount()-1
        index = self.model().index(lastRow, 0)
        self.scrollTo(index)
        l.debug("show last row %s" % lastRow)

    def addRow(self, index, height, id, io):
        self.setColumnWidth(0,self.width() - 100)
        self.insertRow()
        row = self.rowCount()-1
        self.setRowHeight(row,height)            
        # calculate the contents of this row and cache them as a pixmap
        content = equation.DrawObject.drawobjects[index]
        pixmap = None
        if content.textOnly == False:
            columnwidth = self.columnWidth(0)
            try:
                pixmap = self.getPixmap(content.node, columnwidth)
                content.pixmap = pixmap
            except:
                pass
        content.io = io
        pixItem = QtGui.QTableWidgetItem(str(index))
        pixItem.equationIndex = index
        #l.debug("set pix data for row %s" % row)
        #l.debug("my item delegate is " + repr(self.itemDelegate()))
        pixItem.setData(QtCore.Qt.UserRole, QtCore.QVariant(index))
        self.setItem(row,0,pixItem)
        rowIdHeaderItem = QtGui.QTableWidgetItem(str(id))
        self.setVerticalHeaderItem(row, rowIdHeaderItem)
        self.showLastRow()

    def getPixmap(self,node, width):
        if node.getType() != 'PIX':
            try:
                node = node.layoutNode(0,0,width, self.control.initialFontSize)
                node.setTextPosition(5,node.h - node.operatorcentreline)
                pixmap = QtGui.QPixmap(QtCore.QSize(node.w+30,node.h+30))
                painter = qt4factory.Painter(pixmap)
                painter.eraseRect(0,0,node.w+50,node.h+50)
                node.drawNode(painter)
                painter.end()
            except:
                l.exception("drawing node")
                return None
        else:
            pixmap = node.term2
        return pixmap

    def deleteCurrentRow(self):
        rowNo = self.currentRow()
        self.removeRow(rowNo)
        self.data.pop(rowNo)

    def getRowData(self, row):
        rowIndex = row
        dataIndex = equationData[rowIndex][0]
        content = drawobject.drawobjects[dataIndex]
        io = equationData[rowIndex][1]
        return (content, io)

    def columnWidthChanged(self,col):
        QTable.columnWidthChanged(self,col)
        # it would be nice to update the contents iro line breaking but this is very expensive as the table gets large
        # I suppose we could just change what's on view......
        # we'll just update the last row for now
        lastrow = self.numRows()-1
        l.debug( "lastrow is " + repr(lastrow))
        if lastrow == -1:
            return
        content = self.getRowData(lastrow)[0]
        if content.textOnly == False:
            l.debug( "resize last row")
            pixmap = self.getPixmap(content.node, self.columnWidth(0))
            self.setPixmap(lastrow,0,pixmap)
        

            
