
import os, sys

config = None

__initialised=False
def initialise(reInitialise=False):
    global __initialised, config
    config = {}
 
    initConfig()
    initDirs()
    
    __initialised = True
    
def initConfig():
    config["homedir"] = os.path.expanduser("~")
    config["settingsdir"] = os.path.join(config["homedir"],".kayali")
    config["tempdir"] = os.path.join(config["settingsdir"],"tmp")
    config["logfile"] = os.path.join(config["tempdir"],"kayali.log")
    dir,fileName = os.path.split(__file__)
    config["kayalidir"] = dir
    config["maximatokensfile"] = os.path.join(config["kayalidir"],"MaximaParserTokenTypes.txt")
    
    # the space between line breaks
    config["linebreakspace"] = 10
    
    config["shownodedebugger"] = False
    if "SHOW_NODE_DEBUGGER" in os.environ and os.environ["SHOW_NODE_DEBUGGER"].upper() == "TRUE":
        config["shownodedebugger"] = True
    
    config["drawdebugrect"] = False
    if "DRAW_DEBUG_RECT" in os.environ and os.environ["DRAW_DEBUG_RECT"].upper() == "TRUE":
        config["drawdebugrect"] = True
        
    config["scaledcharwidthfactor"] = 0.5/3.0
    
    # ratio by which the font of an exponent decreases
    config["fontreductionratio"] = 0.8
    # extra size of the integral sign over its inner expression
    config["integrateincreaseratio"] = 1.2
    # extra size of the bracket
    config["bracketincreaseratio"]  = 0
    
    config["rootsignwidth"] = 12
    config["roottickwidth"] = 2
    config["roottickheight"] = 3
    config["rootsignextraheight"] = 5
    
    # division spacer
    config["dividerlinespace"] = 6
    
    # font to use in GUI table
    if sys.platform in ["win32","nt"]:
        config["tablefont"] = "Times New Roman" #  or e.g "Bitstream Charter"
    else:
        #config["tablefont"] = "Bitstream Vera Serif" #  or e.g "Bitstream Charter"
	    config["tablefont"] = "Century Schoolbook L" #  or e.g "Bitstream Charter"
    config["tablefontsize"] = 14
    # font to use in PDFs
    config["pdffont"] = "Times-Roman"
    config["pdffontsize"] = 14
    config["pdflinewidth"] = 0.6
    
    # the port to communicate with maxima over
    config["maximaport"] = 4058
    
    for key,value in config.items():
        print key,value

    
def initDirs():
    homeDir = config["homedir"]
    try:
        if not os.path.isdir(config["settingsdir"]):
            os.mkdir(config["settingsdir"])
            if not os.path.isdir(config["tempdir"]):
                os.mkdir(config["tempdir"])
    except:
        print "Unable to create the settings or tmp dir under ",homeDir
        print "Please check that ",homeDir, "is writable."
    

initialise()
    
