#ifndef _REGEX_H
#define _REGEX_H

#include <gc/gc.h>
#include <pcre.h>
#include "Heap.h"

class Array;

class Match : public gc 
{
public:
    bool matched;
    Array* matches;

    wchar_t* before;
    wchar_t* after;
};

// ECB 26/2/07 - this should be done by throwing a kaya_internalError(),
// catching the exception in the .k and rethrowing. This method should be 
// reserved for built in exceptions, because it relies on a specific method
// of name decoration (which we don't want programmers to need to know about)
// and is a bit messy.
//#define REGEX_COMPILATION_FAILED _ns__D_Regex__D_RegexCompilationFailed
//extern char* REGEX_COMPILATION_FAILED;

extern "C" {

void* re_compile(void* vm, wchar_t* pattern, kint len, kint flagcode);
void* re_match(void* vm, void* pc, wchar_t* str, kint len);

Array* getmatches(void* mo);
bool matched(void* mo);
wchar_t* getBefore(void* mo);
wchar_t* getAfter(void* mo);

}

#endif
