/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATFULLTEXTJOB_H_
#define _KATFULLTEXTJOB_H_

#include <kio/job.h>
#include <kfileitem.h>
#include "kat_export.h"

class KAT_EXPORT KatFullTextJob : public KIO::Job
{
Q_OBJECT

public:
    KatFullTextJob( const KFileItemList &items, const QStringList *enabledPlugins, bool deleteItems = false );
    virtual ~KatFullTextJob();

    void removeItem( const KFileItem* item );

    static QStringList availablePlugins();

    static QStringList supportedMimeTypes();

signals:
    void gotFullText( KIO::Job*, const KFileItem* item, const QString& fullText );
    void failed( const KFileItem *item );

protected:
    void getFullText();

protected slots:
    virtual void slotResult( KIO::Job* job );

private slots:
    void start();
    void slotFullText( KIO::Job*, const QByteArray& );

private:
    void determineNextFile();
//        void saveFullText( const QByteArray fullText );

private:
    struct KatFullTextJobPrivate* d;
};

KatFullTextJob* fileFullText( const KFileItemList& items );

KatFullTextJob* fileFullText(const KURL::List& items );

#endif // _KATFULLTEXTJOB_H_
