/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Praveen Kandikuppa : praveen9@gmail.com                               *
 *                                                                         *
 *   This whole implementation has been copied from beagle                 *
 *   Credits actually go to Beagle Team for writing this implementation    *
 *   of inotify                                                            *
 *                                                                         *
 *   --------------------------------------------------------------------- *
 *   Copyright (C) 2004 Novell, Inc.                                       *
 *                                                                         *
 *   Permission is hereby granted, free of charge, to any person obtaining *
 *   a copy of this software and associated documentation files            *
 *   (the "Software"), to deal in the Software without restriction,        *
 *   including without limitation the rights to use, copy, modify, merge,  *
 *   publish, distribute, sublicense, and/or sell copies of the Software,  *
 *   and to permit persons to whom the Software is furnished to do so,     *
 *   subject to the following conditions:                                  *
 *                                                                         *
 *   The above copyright notice and this permission notice shall be        *
 *   included in all copies or substantial portions of the Software.       *
 *                                                                         *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,       *
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF    *
 *   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT *
 *   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY  *
 *   CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,  *
 *   TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE     *
 *   SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                *
 *   --------------------------------------------------------------------- *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef INOTIFY_QT_H
#define INOTIFY_QT_H

#include <qdir.h>
#include <qmap.h>
#include <qdict.h>
#include <qintdict.h>

#include "inotify.h"
#include "kat_export.h"
#include "katwatcher.h"

class Watched;
class QueuedEvent;
class PendingMove;
class SnarfThread;
class DispatchThread;

typedef QValueList<QueuedEvent> EventQueue;
typedef QValueList<QueuedEvent>::iterator EventQueueIterator;
typedef QMap<uint,QueuedEvent> PendingMoveMap;
typedef QIntDict<Watched> WatchedDescriptorDict;
typedef QDict<Watched> WatchedPathDict;

class KAT_EXPORT Inotify : public KatWatcher
{
Q_OBJECT

public :
    friend class SnarfThread;
    friend class DispatchThread;

    enum EventType {
        Access         = 0x00000001, // File was accessed
        Modify         = 0x00000002, // File was modified
        Attrib         = 0x00000004, // File changed attributes
        CloseWrite     = 0x00000008, // Writable file was closed
        CloseNoWrite   = 0x00000010, // Non-writable file was close
        Open           = 0x00000020, // File was opened
        MovedFrom      = 0x00000040, // File was moved from X
        MovedTo        = 0x00000080, // File was moved to Y
        Create         = 0x00000100, // Subfile was created
        Delete         = 0x00000200, // Subfile was deleted
        DeleteSelf     = 0x00000400, // Self was deleted

        Unmount        = 0x00002000, // Backing fs was unmounted
        QueueOverflow  = 0x00004000, // Event queue overflowed
        Ignored        = 0x00008000, // File is no longer being watched

        IsDirectory    = 0x40000000, // Event is against a directory
        OneShot        = 0x80000000, // Watch is one-shot

            // For forward compatibility, define these explicitly
        All            = Inotify::Access | Inotify::Modify | Inotify::Attrib |
                Inotify::CloseWrite | Inotify::CloseNoWrite | Inotify::Open |
                Inotify::MovedFrom | Inotify::MovedTo | Inotify::Create |
                Inotify::Delete | Inotify::DeleteSelf
    };

    // Constructor
    Inotify( QObject *, const char* , const QStringList& );
    ~Inotify();

    bool enabled();

    void startWatcher();
    void stopWatcher ();

    int watchCount() { return watched_by_wd.count(); };

    bool running();

    /* fpath must be an absolute path */
    bool isWatching ( const QString &fpath );

    int watch ( QString path, EventType mask = All );

    int watch ( QString path, KatWatcher::EventType mask );

    // fpath must be an absolute path
    int ignore ( const QString &fpath );

private:
    int inotify_fd;

    bool verbose;

    EventType base_mask;

    EventQueue event_queue;
    PendingMoveMap pending_move_cookies;

    WatchedPathDict watched_by_path;
    WatchedDescriptorDict watched_by_wd;

    SnarfThread *snarf_thread;
    DispatchThread *dispatch_thread;

    // Update the watched_by_path hash and the path stored inside the watch
    // in response to a move event.
    void moveWatch (Watched *watch, QString name);

    // A directory we are watching has moved.  We need to fix up its path, and the path of
    // all of its subdirectories, their subdirectories, and so on.
    void handleMove (QString srcpath, QString dstpath);

    void sendEvent (Watched *watched, QString filename, QString srcpath, EventType mask);

    Watched* lookup (int wd );

    // The caller has to handle all locking itself
    void forget (Watched *watched);
};

#endif
