/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Praveen Kandikuppa : praveen9@gmail.com                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _CATALOGSTATUSITEM_H_
#define _CATALOGSTATUSITEM_H_

#include <qstring.h>

class QWidget;
class QLabel;
class QButtonGroup;
class QPushButton;
class KProgress;

class KatCatalog;

class CatalogStatusItem : public QFrame
{
Q_OBJECT

public:
    CatalogStatusItem( QWidget*, const char* name = 0 );
    ~CatalogStatusItem();
    void setCatalog( KatCatalog*, const int&, const QString&, const int&, const QString&, const int&, const QString& );
    void removeCatalog();
    void updateButton();

public slots:
    void slotUpdateStatus( const int&, const QString& );
    void slotUpdateSubStatus( const int&, const QString& );
    void slotUpdateExtractStatus();
    void slotDetail( bool );
    void slotUpdateProgress( int );
    void slotUpdateCurrentFile( const QString& );

signals:
    void stop();
    void start();
    void pause();
    void ajustDialogSize();

private:
    KatCatalog* m_cat;

    KProgress* pProgress;

    QButtonGroup* bgStats;
    QLabel* tlCurrentFile;
    QLabel* tlStatus;
    QLabel* tlSubStatus;
    QLabel* tlCatalogDetail;
    QLabel* tlFiles;
    QLabel* tlFoldersNum;
    QLabel* tlArchives;
    QLabel* tlArchivesNum;
    QLabel* tlFileSize;
    QLabel* tlFileSizeNum;
    QLabel* tlWordsNum;
    QLabel* tlFolders;
    QLabel* tlWords;
    QLabel* tlFilesNum;
    QLabel* tlMetaData;
    QLabel* tlMetaDataNum;
    QLabel* tlFullTexts;
    QLabel* tlFullTextsNum;
    QLabel* tlThumbnails;
    QLabel* tlThumbnailsNum;
    QLabel* pixmapLabel1;

    QPushButton* detailButton;
    QPushButton* startButton;
    QPushButton* pauseButton;
    QPushButton* stopButton;
};

#endif // _CATALOGSTATUSITEM_H_
