import os
from datetime import date, datetime
from HTMLTags import *
import md5

import k_config

import gadfly

def makeDict(res):
    # convert the result of a cursor.fetchall() to a list
    # of dictionaries
    records = []
    for item in res:
        records.append(dict([(fname,item[i])
            for (i,fname) in enumerate(['recno']+field_names)]))
    return records

__id__ = 'recno'

Types = {
    int : 'INTEGER',
    str : 'VARCHAR',
    float : 'FLOAT',
    datetime : 'VARCHAR',
    date : 'VARCHAR'
    }


#parameters
from genScript import Field
from datetime import date,datetime

name = 'app_gadfly'
fields = [Field('name',str,'input'),
Field('age',int,'input'),
Field('birth',date,'calendar')]
dbmodule = 'gadfly'
security = 'standard'
base_name = 'test'
host = 'localhost'
user = 'root'
passwd = 'passwd'


field_names = [ f.name for f in fields ]
field_types = [ Types[f.Type] for f in fields ]

# open connection
table_name = os.path.basename(name)
table_dir = os.path.dirname(name)

try:
    connection = gadfly.gadfly(table_name,table_dir)
    cursor = connection.cursor()
except IOError:
    connection = gadfly.gadfly()
    connection.startup(table_name,table_dir)
    field_def = ', '.join(['recno INTEGER'] +         ['%s %s' %(n,t) for (n,t) in zip(field_names, field_types)])
    sql = 'CREATE TABLE %s (%s)' %(name,field_def)
    cursor = connection.cursor()
    cursor.execute(sql)



#header
header=HEAD(LINK(rel="stylesheet",href="../../default.css") +
    TITLE(name))

user_test = hasattr(Session(),'app_gadfly_user')

def index():
    print '<html>\n'
    print header
    print H1(name)
    # select all the items and return a list of dictionaries, one
    # for each record, indexed by the field names
    cursor.execute('SELECT %s FROM %s' %(','.join(['recno']+field_names),name))
    records = makeDict(cursor.fetchall())


    if records:
        print '<table class="main" cellpadding="3" cellspacing="0">'
        print '<tr>'
        print Sum([TH(f,Class="main") for f in field_names])
        if user_test:
            print TH('&nbsp;',Class="main")*2
        print '</tr>\n'
        counter = 0
        for record in records:
            counter+=1
            if counter % 2:
                print '<tr class="even">'
            else:
                print '<tr class="odd">'
            for f in field_names:
                print TD(record[f],Class="main")
            if user_test:
                print TD(A('Remove',
                    href="removeRecord?record_id=%s" %record[__id__]),
                    Class="main")
                print TD(A('Edit',
                    href="editRecord?record_id=%s" %record[__id__]),
                    Class="main")
            print '</tr>'
        print '</table>'
    else:
        print "Empty base"

    if user_test:
        print '<p><a href="editRecord?record_id=-1">New record</a>'
        print '<p><a href="logout">Logout</a>'
    else:
        print '<p><a href="login">Login</p>'

    print '</body>\n</html>'

def editRecord(record_id):
    record_id=int(record_id)
    print header
    print '<body>'
    print SCRIPT(Type='text/JavaScript',src='../scw.js')
    print '<script>scwDateOutputFormat  = "YYYY-MM-DD"'
    print 'scwDateInputSequence = "YMD"'
    print '</script>'

    if record_id>-1:
        field_string = ','.join(field_names)
        sql = 'SELECT recno,%s FROM %s WHERE recno = %s'             %(field_string,name,record_id)
        cursor.execute(sql)
        record = makeDict(cursor.fetchall())[0]

        print H1("Editing a record")
    else:
        print H1("New record")
        record=dict([(f,'') for f in field_names])
    
    print '<form action="insertRecord" method="post">'

    print INPUT(type="hidden",name="record_id",value=record_id)
    print '<table>'
    for field in fields:
        fn = field.name
        if field.input_format == 'textarea':
            print TR(TD(fn)+
                  TD(TEXTAREA(record[fn],name="fn",rows="10",cols="50")))          
        elif field.input_format == 'calendar':
            print TR(TD(fn)+
                  TD(INPUT(name=fn,id=fn,size="20",value=record[fn])+
                    A(IMG(src="../Calandar.gif",border=0),
                    href= "javascript:scwShow(document.getElementById('%s'), this);" %fn)))
        else:
            print TR(TD(fn)+
                     TD(INPUT(name=fn,size="40",value=record[fn])))
    print '</table>'
    print INPUT(type="submit",value="Ok")
    print '</form>'
    print '</body>\n</html>'

def insertRecord(record_id,**untyped_fields):

    record_id=int(record_id)
    
    # get next id
    sql="SELECT MAX(recno) FROM %s" %name
    try:
        cursor.execute(sql)
        res=cursor.fetchall()
        next_id = res[0][0]+1
    except ValueError: # empty base
        next_id = 0

    # replace single quotes by double quotes
    for (k,v) in untyped_fields.items():
        untyped_fields[k]=v.replace("'","''")
    if record_id == -1:
        field_string = 'recno,' + ','.join(field_names)
        vals = '%s,' %next_id + ','.join([ "'%s'" %untyped_fields[f] 
            for f in field_names])
        sql = 'INSERT INTO %s (%s) VALUES (%s)' \
            %(name,field_string,vals)
    else:
        vals = ','.join(["%s = '%s'" %(k,v) 
            for (k,v) in untyped_fields.iteritems()])
        sql = 'UPDATE %s SET %s WHERE recno = %s' %(name,vals,record_id)
    cursor.execute(sql)
    connection.commit()
    connection.close()
    
    raise HTTP_REDIRECTION,"index"

def removeRecord(record_id):
    
    sql = 'DELETE FROM %s WHERE recno = %s' %(name,record_id)
    cursor.execute(sql)
    connection.commit()
    connection.close()

    raise HTTP_REDIRECTION,"index"

def login():
    print H1("Login")
    print '<form action="check_login" method="post">'
    print TABLE(
        TR(TD("Login")+TD(INPUT(name="login"))) +
        TR(TD("Password")+
            TD(INPUT(name="password", Type="password"))) +
        TR(TD(INPUT(Type="submit",value="Ok"))+
            TD("&nbsp;"))
        )
    print '</form>'

def check_login(**user_data):
    digest=open("app_gadfly.ini","rb").read()
    userDigest=digest[:16]
    passwordDigest=digest[16:]

    if (md5.new(user_data['login']).digest()==userDigest \
            and md5.new(user_data['password']).digest()==passwordDigest):
        setattr(Session(),'%s_user' %name, user_data['login'])
        raise HTTP_REDIRECTION,'index'
    else:    
        print "Authentication failed"
        print P(A("Back",href="index"))

def logout():
    Session().close()
    raise HTTP_REDIRECTION,'index'
    
def error(msg):
    print header
    print H1(pageTitle)
    print msg
    print P(A('Back',href='index'))
