"""Karrigell script for managing the database test
Generated 25-02-2006 14:01:01
"""
import os
from HTMLTags import *
import md5

# database-specific modules
import strakell

def makeDict(res):
    # convert the result of a cursor.fetchall() to a list
    # of dictionaries
    records = []
    for item in res:
        records.append(dict([(fname,item[i])
            for (i,fname) in enumerate(['recno', 'name'])]))
        for (fn,ft) in zip(field_names,field_types):
            if ft == 'text':
                records[-1][fn] = records[-1][fn].encode('utf-8')
    return records

#parameters
name = "test"
pageTitle = "Managing base test"
field_names = ['name']
field_types = ['text']
db = strakell.Base('test.stk')
if not os.path.exists('test.stk'):
    db.create(name=str)
else:
    db.open()

#header
header=HEAD(LINK(rel="stylesheet",href="../default.css") +
    TITLE(pageTitle))

def index():
    user_test = True # default
    print '<html>\n'
    print header
    print H1(pageTitle)
    records = [ r for r in db ]

    if records:
        print '<table class="main" cellpadding="3" cellspacing="0">'
        print '<tr>'
        print Sum([TH(f,Class="main") for f in field_names])
        if user_test:
            print TH('&nbsp;',Class="main")*2
        print '</tr>\n'
        counter = 0
        for record in records:
            counter+=1
            if counter % 2:
                print '<tr class="even">'
            else:
                print '<tr class="odd">'
            print TD(record.name,Class="main")
            if user_test:
                print TD(A('Remove',
                    href="removeRecord?recordId=%s" %record.__id__),
                    Class="main")
                print TD(A('Edit',
                    href="editRecord?recordId=%s" %record.__id__),
                    Class="main")
            print '</tr>'
        print '</table>'
    else:
        print "Empty base"

    if user_test:
        print '<p><a href="editRecord?recordId=-1">New record</a>'

    print '</body>\n</html>'

def editRecord(recordId):
    recordId=int(recordId)
    print header
    print '<body>'

    if recordId>-1:
        record = db[recordId]
        print H1("Editing a record")
    else:
        print H1("New record")
        record = strakell.Row({'name':''})
    
    print '<form action="insertRecord" method="post">'

    print INPUT(type="hidden",name="recordId",value=recordId)
    print '<table>'
    print TR(TD("name")+TD(INPUT(name="name",size="40",value=record.name)))
    print '</table>'
    print INPUT(type="submit",value="Ok")
    print '</form>'
    print '</body>\n</html>'

def insertRecord(recordId,**untyped_fields):

    recordId=int(recordId)
    # replace single quotes by double quotes
    if recordId==-1:
        db.write(**untyped_fields)
    else:
        record = db[recordId]
        for k,v in untyped_fields.iteritems():
            setattr(record,k,v)
    db.commit()
    raise HTTP_REDIRECTION,"index"

def removeRecord(recordId):

    db.remove([r for r in db if r.__id__ == int(recordId) ])
    db.commit()
    raise HTTP_REDIRECTION,"index"

def login():
    print H1("Login")
    print '<form action="check_login" method="post">'
    print TABLE(
        TR(TD("Login")+TD(INPUT(name="login"))) +
        TR(TD("Password")+
            TD(INPUT(name="password", Type="password"))) +
        TR(TD(INPUT(Type="submit",value="Ok"))+
            TD("&nbsp;"))
        )
    print '</form>'

def check_login(**user_data):

    if users_cursor is not None:
        sql = "SELECT recno,login,password FROM "
        sql += " WHERE login = '%s' AND password = '%s'" \
            %(user_data['login'],user_data['password'])
        users_cursor.execute(sql)
        user_record = users_cursor.fetchall()
        if user_record:
            user_record = dict(zip(['recno','login','password'],user_record[0]))
    else:
        user_record = None

    if not user_record:
        print "Unknown user"
        print P(A("Back",href="index"))
    else:
        setattr(Session(),'%s_user' %name, user_record['recno'])
        raise HTTP_REDIRECTION,'index'

def logout():
    Session().close()
    raise HTTP_REDIRECTION,'index'
    
def error(msg):
    print header
    print H1(pageTitle)
    print msg
    print P(A('Back',href='index'))
