import os
from HTMLTags import *
import genScript
import cgi
import datetime

class ConfigError(Exception):
    pass

def _options(optlist,selected=None):
    """Return the options with one selected"""
    return Sum(OPTION(t,value=t,selected = (t == selected)) for t in optlist)

def _edit_field(objname,obj):
    """Return the form to show, remove and add the field names,
    types and input format for obj = fields or users_fields"""
    e_fields = TR(TD('Name')+TD('Type')+TD('Input format')+
        TD('Action',colspan="2"))
    
    for i,f in enumerate(getattr(Session().base,obj)):
        if obj == 'users_fields' and f.name in ['login','password']:
            e_fields += TR(
                    TD(INPUT(type="hidden",value=f.name,name="field",rows=1)+TEXT(f.name))+
                    TD(INPUT(type="hidden",value='str',name="Type_%s_%s" %(obj,i))+TEXT('str')) +
                    TD(INPUT(Type="hidden",value='input',name="format_%s_%s" %(obj,i))+TEXT('input')) +
                    TD(TEXT('&nbsp')
                          ))
        else:
            e_fields += TR(
                    TD(INPUT(value=f.name,name="field",rows=1))+
                    TD(SELECT(_options(genScript.types.keys(),f.Type.__name__),
                        name="Type_%s_%s" %(obj,i),
                        id="Type_%s_%s" %(obj,i),
                        onChange="change('%s',%s)" %(obj,i)))+
                    TD(SELECT(
                        _options(genScript.formats[f.Type],f.input_format),
                        name="format_%s_%s" %(obj,i),
                        id="format_%s_%s" %(obj,i),
                        )) +
                  TD(INPUT(Type="button",value="Remove",
                            onclick="move('%s',%s)" %(obj,i))
                          ))
    new_field = TR(TD(INPUT(name="field_%s_new" %obj,id="field_%s_new" %obj))+
                    TD(SELECT(_options(genScript.types.keys()),
                        name="Type_%s_new" %obj, id="Type_%s_new" %obj,
                        onChange="change('%s','new')" %obj))+
                    TD(SELECT(
                        _options(genScript.formats[str]),
                            name="format_%s_new" %obj,
                            id="format_%s_new" %obj) +
                    TD(INPUT(Type="button",value="Add",
                             onclick="add('%s')" %obj),
                             colspan="2"),
                    ))
    e_fields = TR(TD(TABLE(e_fields+new_field,border="1")))
    return e_fields

def index():
    if hasattr(Session(),'base'):
        del Session().base  # clear session object
    print H1("Karrigell script generator")
    print "This program will generate a script to manage a database"
    print "<br>Enter the application name"

    print FORM(INPUT(name="appname")+INPUT(Type="submit",value="Ok"),
        action="edit")

def edit(appname=''):
    """Edit configuration file"""
    if not appname:
        if not hasattr(Session(),'base'):
            raise ConfigError,"You must provide an application name"
        else:
            appname = Session().base.name
            filename = Session().base.filename
    else:
        filename = appname + '.py'
        if os.path.exists(filename):
            Session().base = genScript.get_vars(filename)
        else:
            Session().base = genScript.get_vars('_default.py')
            Session().base.filename = filename
            Session().base.name = appname
            Session().base.page_title = "Managing base %s" %appname

    title = "Editing application %s" %appname

    e_page_title = TR(TD('Page title')+TD(INPUT(name="page_title",
                                          value=Session().base.page_title)))
    e_dbmodule = TR(TD("Database")+
                    TD(SELECT(_options(['kirbybase','gadfly','sqlite'],
                                Session().base.dbmodule),
                       name="dbmodule")))
    e_fields = _edit_field('Fields','fields')
    
    e_stylesheet = TR(TD('Style sheet')+
                      TD(INPUT(name="stylesheet",
                            value=Session().base.stylesheet)))
    e_datadir = TR(TD('Data directory')+
                      TD(INPUT(name="data_directory",
                               value=Session().base.data_directory)))

    e_security = TR(TD("Security level")+
                    TD(SELECT(_options(['low','standard','high'],
                        Session().base.security),name="security",
                        onChange="change_sec(this)")))

    e_users_name = TR(TD('Users name')+
                      TD(INPUT(name="users_name",
                               value=Session().base.users_name)))
    e_users_fields = _edit_field('Users fields','users_fields')
    e_login = TR(TD(TEXT('Administrator')+BR()+TEXT('Login'))+
        TD(INPUT(name='login')))
    e_password = TR(TD('Password')+TD(INPUT(name="password",type="password")))

    print HEAD(SCRIPT(src='../genScript.js')+
               LINK(rel="stylesheet",Type="text/css",href="../genScript.css"))
    entries = e_page_title+e_dbmodule+e_stylesheet+e_datadir+e_security
    tb = TABLE(TR(TD(TABLE(entries),Class="block")+
                  TD(TABLE(e_fields),Class="block")))
    if Session().base.security != 'low':
        tb += TABLE(TR(TD(TABLE(e_users_name + e_login + e_password),Class="block") +
                       TD(TABLE(e_users_fields),Class="block")))
    tb += TR(TD(INPUT(Type="submit",colspan="2",value="Save changes and generate script")))
    print BODY(TEXT(title) + FORM(tb,method="post",action="makeScript"))
            
def remove(obj,ix):
    del getattr(Session().base,obj)[int(ix)]
    raise HTTP_REDIRECTION,"edit"
    
def add(obj,field,Type,format):
    s = Session().base
    if not field:
        raise SCRIPT_ERROR,'You must enter a field name'
    
    fields = getattr(s,obj)
    for f in fields:
        if f.name == field:
            raise SCRIPT_ERROR,'Name %s already exists' %field

    Type = genScript.types[Type]
    getattr(s,obj).append(genScript.Field(field,Type,format))
    raise HTTP_REDIRECTION,"edit"

def update(**args):
    _update(**args)
    raise HTTP_REDIRECTION,"edit"

def _update(**args):
    s = Session().base
    for k,v in args.iteritems():
        if k.startswith('field_'):
            elts = k.split('_')
            at,i = elts[0],elts[-1]
            obj = '_'.join(elts[1:-1])
            if i == 'new':
                fname = args['field_%s_new' %obj]
                if fname:
                    getattr(s,obj).append(
                        genScript.Field(fname,
                        genScript.types[args['Type_%s_new'%obj]],
                        args['format_%s_new' %obj]))
            else:
                setattr(getattr(s,obj)[int(i)],at,v)
        elif k.startswith('Type_') or k.startswith('format_'):
            elts = k.split('_')
            at,i = elts[0],elts[-1]
            obj = '_'.join(elts[1:-1])
            if at == 'Type':
                v = genScript.types[v]
            elif at == 'format':
                    at = 'input_format'
            if i != 'new':
                setattr(getattr(s,obj)[int(i)],at, v)
        else:
            setattr(s,k,v)

def makeScript(**args):
    _update(**args)
    try:
        _save()
    except ConfigError,msg:
        print msg
        print '<br><a href="edit">Back</a>'
        return
    except:
        raise
        
    genScript.generate_script(Session().base.name)
    print "Script <b>%s.ks</b> generated<br>" %Session().base.name
    print '<a href="../%s.ks">Test it</a>' %Session().base.name

def update_field(obj,field,Type,format,ix):
    Type = genScript.types[Type]
    getattr(Session().base,obj)[int(ix)] = genScript.Field(field,Type,format)
    raise HTTP_REDIRECTION,"edit"

def _save():
    s = Session().base
    if s.security != 'low':
        abspath = os.path.join(os.path.normpath(s.data_directory),s.name)
        admin_file = '%s.ini' %abspath
        if not s.login or not s.password:
            if not os.path.exists(admin_file):
                raise ConfigError,'Administrator login or password missing'
        else:
            genScript.save_admin_info(admin_file,s.login,s.password)

    out = open('%s.py' %Session().base.name,'w')
    w = out.write
    w("from genScript import Field\n")
    w("from datetime import date,datetime\n")
    w("fields = [" + ",\n".join("    Field('%s',%s,'%s')" 
        %(f.name,f.Type.__name__,f.input_format)
        for f in s.fields)+']\n')
    w('data_directory = r"%s"\n' %s.data_directory)
    for attr in ['dbmodule','stylesheet','security','page_title']:
        w("%s = '%s'\n" %(attr,getattr(s,attr)))
    if Session().base.security != 'low':
        w("users_name = '%s'\n" %s.users_name)
        w("users_fields = [" + ",\n".join("    Field('%s',%s,'%s')" 
            %(f.name,f.Type.__name__,f.input_format)
            for f in s.users_fields)+']\n')
            
    out.close()
