"""
File: blogdb.py
Author: AN
Date: Jan 2006
Description:

Contains the code related to saving, retrieving, editing and deleting blog
entries.

Todo:
- User management
- Change field names so entryid -> recno
"""

import os
import time

from kirbybase import KirbyBase

class BlogDB:
    def __init__(self):
        self.dbname = 'blog.tbl'
        self.db = self.getconnection()
        # The field names as the .ks expects them
        self.fieldnames = ('entryid', 'date', 'subject', 'body', 'username')
        # The field names as the db expects them
        self.dbnames = ('recno', 'date', 'subject', 'body', 'username')
       
    def getconnection(self):
        """Get a kirbybase connection"""
        db = KirbyBase()
        if os.path.exists(self.dbname):
            return db
        else:
            db.create(self.dbname,
                ['username:str', 'date:int', 'subject:str', 'body:str'])
            return db
        
    def getentry(self, entryid):
        """Fetch an entry for a given entry id"""
        if not entryid.isdigit():
            return None
        
        entry = self.db.select(self.dbname, ['recno'], [int(entryid)], self.dbnames)

        if len(entry) != 1:
            return None
        return [dict(zip(self.fieldnames, entry[0]))]

    def getlastposts(self, number):
        """Get the <number> most recent posts"""
        # No limit operator? Will fetch the record number instead and
        # truncate that list ...
        recnos = self.db.select(self.dbname, ['recno'], ['*'], ['recno'])
        recnos = [recno[0] for recno in recnos[:number]]
        # So we get <number> most recent records.
        posts = self.db.select(self.dbname, ['recno'], [recnos], self.dbnames)
        # Cast to dict and return
        return [dict(zip(self.fieldnames, post)) for post in posts]

    def getheaders(self):
        """Return date, title tuples"""
        return self.db.select(self.dbname, ['recno'], ['*'],
            ['recno', 'date', 'subject'], sortFields=['date'])

    def saveentry(self, username, entryid, subject, body):
        """Save or create a new entry (if entryid is 'new').
        Returns the entry id or """
        # New entry, insert
        if entryid == 'new':
            date = int(time.time())
            return self.db.insert(self.dbname, [username, date, subject, body])
        # Existing entry, update
        elif entryid.isdigit():
            self.db.update(
                self.dbname,
                ['recno'], [int(entryid)],
                    {'username': username, 'subject': subject, 'body': body}
                )
            return int(entryid)
        # None of the above. Fails.
        else:
            return None
        
    def deleteentry(self, entryid):
        pass