"""Karrigell script for managing the database students
Generated 06-11-2005 16:33:55
"""
import os
from HTMLTags import *
import md5

# database-specific modules
import gadfly

def makeDict(res):
    # convert the result of a cursor.fetchall() to a list
    # of dictionaries
    records = []
    for item in res:
        records.append(dict([(fname,item[i])
            for (i,fname) in enumerate(['recno', 'login', 'password', 'email', 'klass'])]))
    return records

info = open(r'c:\karrigell\data\books.ini').readlines()
admin_login = info[0].strip()
admin_password = info[1].strip()
def authTest():
    return (AUTH_USER==admin_login
        and md5.new(AUTH_PASSWORD).digest()==admin_password)

Authentication(authTest,
    realm=_("Administration"),
    errorMessage=_("Authentication error"))

#parameters
name = "students"
pageTitle = "books users"
field_names = ['login', 'password', 'email', 'klass']
field_types = ['varchar', 'varchar', 'varchar', 'varchar']
try:
    connection = gadfly.gadfly('students',r'c:\karrigell\data')
    cursor = connection.cursor()
except IOError:
    connection = gadfly.gadfly()
    connection.startup('students',r'c:\karrigell\data')
    cursor = connection.cursor()
    cursor.execute('CREATE TABLE students (recno integer, login varchar, password varchar, email varchar, klass varchar)')

#header
header=HEAD(LINK(rel="stylesheet",href="../default.css") +
    TITLE(pageTitle))

def index():
    user_test = True # default
    print '<html>\n'
    print header
    print H1(pageTitle)
    cursor.execute('SELECT recno,login,password,email,klass FROM students')
    records = makeDict(cursor.fetchall())

    if records:
        print '<table class="main" cellpadding="3" cellspacing="0">'
        print '<tr>'
        print Sum([TH(f,Class="main") for f in field_names])
        if user_test:
            print TH('&nbsp;',Class="main")*2
        print '</tr>\n'
        counter = 0
        for record in records:
            counter+=1
            if counter % 2:
                print '<tr class="even">'
            else:
                print '<tr class="odd">'
            print TD(record["login"],Class="main")
            print TD(record["password"],Class="main")
            print TD(record["email"],Class="main")
            print TD(record["klass"],Class="main")
            if user_test:
                print TD(A('Remove',
                    href="removeRecord?recordId=%s" %record['recno']),
                    Class="main")
                print TD(A('Edit',
                    href="editRecord?recordId=%s" %record['recno']),
                    Class="main")
            print '</tr>'
        print '</table>'
    else:
        print "Empty base"

    if user_test:
        print '<p><a href="editRecord?recordId=-1">New record</a>'
    print '</body>\n</html>'

def editRecord(recordId):
    recordId=int(recordId)
    if recordId>-1:
        cursor.execute('SELECT recno,login,password,email,klass FROM students WHERE recno = %s'
               %recordId)
        record = makeDict(cursor.fetchall())[0]

        print header
        print H1("Editing a record")
    else:
        print header
        print H1("New record")
        record=dict([(f,'') for f in ['login', 'password', 'email', 'klass']])
    
    print '<form action="insertRecord" method="post">'

    print INPUT(type="hidden",name="recordId",value=recordId)
    print '<table>'
    print TR(TD("login")+TD(INPUT(name="login",size="40",value=record["login"])))
    print TR(TD("password")+TD(INPUT(name="password",size="40",value=record["password"])))
    print TR(TD("email")+TD(INPUT(name="email",size="40",value=record["email"])))
    print TR(TD("klass")+TD(INPUT(name="klass",size="40",value=record["klass"])))
    print '</table>'
    print INPUT(type="submit",value="Ok")
    print '</form>'
    print '</body>\n</html>'

def insertRecord(recordId,**untyped_fields):

    sql="SELECT MAX(recno) FROM students"
    try:
        cursor.execute(sql)
        res=cursor.fetchall()
        next_id = res[0][0]+1
    except ValueError: # empty base
        next_id = 0

    recordId=int(recordId)
    # replace single quotes by double quotes
    for (k,v) in untyped_fields.items():
        untyped_fields[k]=v.replace("'","''")
    if recordId==-1:
        sql = 'INSERT INTO students (recno,login,password,email,klass) VALUES (%s)' \
            %','.join([str(next_id)]+["'%s'" %untyped_fields[n] for n in field_names])
        cursor.execute(sql)
    else:
        vals = ','.join(["%s = '%s'" %(k,v) for (k,v) in untyped_fields.items()])
        sql = 'UPDATE students SET %s WHERE recno = %s' %(vals,recordId)
        cursor.execute(sql)
    connection.commit()
    
    raise HTTP_REDIRECTION,"index"

def removeRecord(recordId):

    sql = 'DELETE FROM students WHERE recno = %s' %recordId
    cursor.execute(sql)
    connection.commit()
    raise HTTP_REDIRECTION,"index"

def login():
    print H1("Login")
    print '<form action="check_login" method="post">'
    print TABLE(
        TR(TD("Login")+TD(INPUT(name="login"))) +
        TR(TD("Password")+
            TD(INPUT(name="password", Type="password"))) +
        TR(TD(INPUT(Type="submit",value="Ok"))+
            TD("&nbsp;"))
        )
    print '</form>'

def check_login(**user_data):

    if users_cursor is not None:
        sql = "SELECT recno,login,password FROM students"
        sql += " WHERE login = '%s' AND password = '%s'" \
            %(user_data['login'],user_data['password'])
        users_cursor.execute(sql)
        user_record = users_cursor.fetchall()
        if user_record:
            user_record = dict(zip(['recno','login','password'],user_record[0]))
    else:
        user_record = None

    if not user_record:
        print "Unknown user"
        print P(A("Back",href="index"))
    else:
        setattr(Session(),'%s_user' %name, user_record['recno'])
        raise HTTP_REDIRECTION,'index'

def logout():
    Session().close()
    raise HTTP_REDIRECTION,'index'
    
def error(msg):
    print header
    print H1(pageTitle)
    print msg
    print P(A('Back',href='index'))
