/***************************************************************************
                          clistview.h  -  description
                             -------------------
    begin                : Tue Jun 27 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CLISTVIEW_H
#define CLISTVIEW_H

#include <klistview.h>

/**This class, derived from QListView, will be used for drag and
drop operations
  *@author Eric Coquelle
  */

class CListView : public KListView  {
Q_OBJECT

public:
	CListView(QWidget *parent, const char *name);
	CListView();
	~CListView();
  /** Start the drag and drop operations by: extracting the
right files, and then send a list of filenames
to the target application */
 void initiateDragAndDrop();

protected: // Protected methods
  /** Intercept mouse moves to allow drag&drop */
  void contentsMouseMoveEvent( QMouseEvent * );
  /**  */
  void contentsMouseReleaseEvent( QMouseEvent * );
  /**  */
  void contentsMousePressEvent( QMouseEvent * );

signals: // Signals
  /** Emit this message to make all files to be extracted
		* and then send datas to the target application
	 */
  void doDragAndDrop(void);

 private:
 	/* Is mouse button pressed ?*/
 	bool mousebuttonpressed;

};

#endif
