
/*
 * Kanatest
 *
 * Copyright (C) 2001-2004, 2006 Tomasz Mąka <pasp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _STATS_H
#define _STATS_H

#define NUMBER_OF_COLUMNS   8

#define STATS_NAME          "kanatest_stats"
#define STATS_FILENAME      "kanatest-stats.xml"

struct stats_entry {
    guint date_day;
    guint date_month;
    guint date_year;
    guint date_hour;
    guint date_minute;
    guint test_mode;
    guint test_time;
    guint test_kana_set;
    guint test_questions;
    guint test_correct_answers;
    guint test_rwaq;
};

void    stats_create_window (void);
void    stats_info_no_stats (void);
void    stats_read_list     (void);
void    stats_write_list    (void);
void    stats_add_entry     (guint day, guint month, guint year, guint hour, guint minute, guint time, 
                             guint mode, guint kana_set, guint questions, guint correct_answers, guint rwaq);
gint    stats_get_records   (void);
void    stats_remove_list   (void);

#endif /* _STATS_H */

