
/*
 * Kanatest
 *
 * Copyright (C) 2001-2004, 2006 Tomasz Mka <pasp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _PREFS_H
#define _PREFS_H

#include <gtk/gtk.h>

#include "test.h"

#define CONFIG_DIRNAME      ".clay"
#define CONFIG_FILENAME     "kanatest.xml"
#define CONFIG_NAME         "kanatest_config"

#define MAX_FONTNAME_LEN    256
#define MAX_COLORNAME_LEN   64
#define MAX_BUFFER_SIZE     1024

struct jpprefs
{
    gint        window_x;
    gint        window_y;
    gint        window_size_x;
    gint        window_size_y;
    gint        repeat_wrong;
    gint        kana_mode;
    gint        kana_set;
    gint        ca_timeout;
    gint        enable_tooltips;
    gint        stat_window_x;
    gint        stat_window_y;
    gint        stat_size_x;
    gint        stat_size_y;
    gint        about_window_x;
    gint        about_window_y;
    gint        options_window_x;
    gint        options_window_y;
    gint        chart_window_x;
    gint        chart_window_y;
    gint        stats_sort_column;
    gint        stats_sort_column_dir;
   	gchar       kana_font_face[MAX_FONTNAME_LEN];
   	gchar       kana_color[MAX_COLORNAME_LEN];
   	gchar       romaji_color[MAX_COLORNAME_LEN];
   	gchar       user_defined_lesson[NUMBER_OF_SIGNS+1];
};

extern  struct jpprefs        config;

void    prefs_read_config       (void);
void    prefs_write_config      (void);

#endif /* _PREFS_H */

