
/*
 * Kanatest
 *
 * Copyright (C) 2001-2004, 2006 Tomasz Mka <pasp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GUI_H
#define _GUI_H

#include <gtk/gtk.h>
#include <time.h>

#define		BUFFER_SIZE		256

typedef enum {
	B_STATS = 0,
	B_ABOUT,
	B_OPTIONS,
	B_CHART,
	B_STOP,
	B_START
} bhandler;

extern 			GtkWidget				*romaji_entry;
extern 			GtkWidget				*stop_button;

extern 			gint					stop_flag;
extern			time_t					start_time;

void			gui_create_window		(void);
void			gui_disable_test		(void);
void			gui_disable_start		(void);
void			gui_display_kana		(gint number, gint mode);
void			gui_set_progress		(void);
void			gui_set_widgets_status	(gint mode);
GtkWidget*		gui_stock_label_button	(gchar *blabel, const gchar *bstock);

#endif /* _GUI_H */

