/***************************************************************************
 *   Copyright (C) 2005 by Anne-Marie Mahfouf   *
 *   annemarie.mahfouf@free.fr   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.             *
 ***************************************************************************/


#include "kalcul.h"
#include "settings.h"
#include "prefs.h"
#include "advanced.h"
#include "timer.h"
#include "missing.h"
#include "exercisedialog.h"
#include "leveleditor.h"

#include <qdragobject.h>
#include <kprinter.h>
#include <qpainter.h>
#include <qwhatsthis.h>

#include <kconfigdialog.h>
#include <kdebug.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kjanuswidget.h>
#include <kkeydialog.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kstatusbar.h>

#include <kstdaccel.h>
#include <kaction.h>
#include <kstdaction.h>

Kalcul::Kalcul()
    : KMainWindow( 0, "Kalcul" ),
      m_view(new KalculView(this)),
      m_printer(0),
      exerciseDialog(new ExerciseDialog(this)),
      levelEditor(new LevelEditor(this))
{
    // accept dnd
    setAcceptDrops(true);

    // tell the KMainWindow that this is indeed the main widget
    setCentralWidget(m_view);
    
    // and a status bar
    statusBar()->show();

    // then, setup our actions
    setupActions();
    
    // apply the saved mainwindow settings, if any, and ask the mainwindow
    // to automatically save settings if changed: window size, toolbar
    // position, icon size, etc.
    setAutoSaveSettings();

    // allow the view to change the statusbar and caption
    connect(m_view, SIGNAL(signalChangeStatusbar(const QString&)),
            this,   SLOT(changeStatusbar(const QString&)));
    connect(m_view, SIGNAL(signalChangeCaption(const QString&)),
            this,   SLOT(changeCaption(const QString&)));
    changeStatusbar( i18n("User: %1").arg(Settings::nameLine() ));

    //TODO: can this be done with less connects?
    connect(exerciseDialog, SIGNAL(signalPracticeAddition()), this, SLOT(practiceAddition()));
    connect(exerciseDialog, SIGNAL(signalPracticeSubtraction()), this, SLOT(practiceSubtraction()));
    connect(exerciseDialog, SIGNAL(signalPracticeMultiplication()), this, SLOT(practiceMultiplication()));
    connect(exerciseDialog, SIGNAL(signalPracticeDivision()), this, SLOT(practiceDivision()));

    connect(exerciseDialog, SIGNAL(setLevel(const QString&)), m_view, SLOT(setLevel(const QString&)));
}

Kalcul::~Kalcul()
{
}

void Kalcul::setupActions()
{
    KStdAction::quit(kapp, SLOT(quit()), actionCollection());

    exerciseDialogAction = new KAction(i18n("Exercise Dialog"), "launch", 0, this, SLOT(showExerciseDialog()), actionCollection(), "exercise_dialog");
    levelEditorAction = new KAction(i18n("Level Editor"), "edit", 0, this, SLOT(showLevelEditor()), actionCollection(), "leveleditor");
    
    KStdAction::preferences(this, SLOT(optionsPreferences()), actionCollection());

    setupGUI();
}

void Kalcul::optionsPreferences()
{
    //KConfigDialog *dialog = new KConfigDialog(this, "settings", Settings::self(), KDialogBase::Swallow);
    KConfigDialog* dialog = new KConfigDialog( this, "settings",  Settings::self() );
    dialog->addPage(new Prefs(), i18n("General"), "package_settings");
    dialog->addPage(new Timer(), i18n("Timer"), "clock");
    dialog->addPage(new advanced(), i18n("Advanced"), "wizard");
    //dialog->addPage(new missing(), i18n("Sequence"), "apply");
    connect(dialog, SIGNAL(settingsChanged()), this, SLOT(settingsChanged()));
    dialog->show();
}

void Kalcul::changeStatusbar(const QString& text)
{
    kdDebug() << "in status " << endl;
    // display the text on the statusbar
    statusBar()->message(text);
}

void Kalcul::changeCaption(const QString& text)
{
    // display the text on the caption
    setCaption(text);
}


void Kalcul::practiceAddition()
{
    m_view->setPracticeMode(Practice_Addition);
    Settings::setOperation(Practice_Addition);
}

void Kalcul::practiceSubtraction()
{
    m_view->setPracticeMode(Practice_Subtraction);
    Settings::setOperation(Practice_Subtraction);
}

void Kalcul::practiceMultiplication()
{
    m_view->setPracticeMode(Practice_Multiplication);
    Settings::setOperation(Practice_Multiplication);
}

void Kalcul::practiceDivision()
{
    m_view->setPracticeMode(Practice_Division);
    Settings::setOperation(Practice_Division);
}

void Kalcul::showExerciseDialog()
{
    exerciseDialog->show();
}

void Kalcul::showLevelEditor()
{
    levelEditor->show();
}

void Kalcul::settingsChanged()
{
    m_view->settingsChanged();
}

#include "kalcul.moc"

