#!/usr/bin/ruby -Ke

## usage: ruby partcsv.rb project-id

kagemai_root = "/home/fukuoka/kagemai"        # setup
config_file  = "#{kagemai_root}/kagemai.conf" # setup

$: << "#{kagemai_root}/lib"
require 'kagemai/config'

Kagemai::Config.initialize(kagemai_root, config_file)

require 'kagemai/bts'
require 'kagemai/project'
require 'kagemai/message_bundle'

module Kagemai

  def self.export(project_id)
    MessageBundle.open(Config[:resource_dir], 
                       Config[:language], 
                       Config[:message_bundle_name])
    
    bts = BTS.new(Config[:project_dir])
    project = bts.open_project(project_id)
    
    project.each do |report|
      line = [report.id]
      report.each_attr do |etype|
        value = report[etype.id].to_s
        line << "\"" + value.gsub(/"/, '""') + "\""
      end
      puts line.join(',')
    end
  end

end

if $0 == __FILE__ then
  unless ARGV.size == 1 then
    puts "usage: ruby export.rb project-id"
    exit 1
  end

  project_id = ARGV.shift
  Kagemai::export(project_id)
end
