/***************************************************************************
                          wizarddialog.cpp  
                             -------------------
    begin                : Son Feb 8 2004
    revision             : $Revision: 1.3 $
    last modified        : $Date: 2004/03/29 10:57:48 $ by $Author: juergenk $
    copyright            : (C) 2004 by Juergen  Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <kdebug.h>
#include <kprocess.h>
#include <kglobal.h>
#include <kstandarddirs.h>

#include <qvbox.h>
#include <qdir.h>
#include <qfile.h>
#include <qstringlist.h>
  
#include "wizarddialog.h"
#include "wizarddialog.moc"


WizardDialog::WizardDialog( QWidget *parent, const char *name ) : KWizard( parent, name )
{
  setCaption( i18n("Kaffeine %1").arg(VERSION) );

  QVBox* page = new QVBox( this );
  page->setSpacing( 20 );
  
  linkMozillaPlugin = new QCheckBox( i18n("Link mozilla plugin with ") + QDir::homeDirPath() + "/.mozilla/plugins", page );
  if ( !QFile::exists( QDir::homeDirPath() + "/.mozilla/plugins/kaffeineplugin.so" ) )
    linkMozillaPlugin->setChecked( true );

  useMMSHelper = new QCheckBox( i18n("Use Kaffeine as helper application for mms:// (Microsoft Media) streams"), page );
  if ( !QFile::exists( QDir::homeDirPath() + "/.kde/share/services/mms.protocol" ) )
    useMMSHelper->setChecked( true );
  
  useRTSPHelper = new QCheckBox( i18n("Use Kaffeine as helper application for rtsp:// (Real Media and others) streams"), page );
  if ( !QFile::exists( QDir::homeDirPath() + "/.kde/share/services/rtsp.protocol" ) )
    useRTSPHelper->setChecked( true );
  
  createDesktopIcon = new QCheckBox( i18n("Create a Kaffeine icon on desktop"), page );
  if ( !QFile::exists( QDir::homeDirPath() + "/Desktop/kaffeine.desktop" ) )
    createDesktopIcon->setChecked( true );

  addPage( page, i18n("Installation Options") );
  setNextEnabled( page, false );
  setBackEnabled( page, false );
  setHelpEnabled( page, false );
  setFinishEnabled( page, true );
}


WizardDialog::~WizardDialog()
{
  kdDebug(555) << "Wizard Dialog Destructed" << endl;
}


void WizardDialog::accept()
{
  kdDebug(555) << "Finished pressed" << endl;

  KProcess process;

  if ( linkMozillaPlugin->isChecked() )
  {
    QString installedPlugin = KAFFEINE_PLUGINDIR;
    installedPlugin.append("/kaffeineplugin.so");

    if (QFile::exists( installedPlugin ))
    {
      kdDebug(555) << "Mozilla-Plugin found: " << installedPlugin << endl;
      QDir plugindir( QDir::homeDirPath()+"/.mozilla");
      plugindir.mkdir("plugins");   /* for sure */
      process << "ln" << "-s" << installedPlugin << QDir::homeDirPath() + "/.mozilla/plugins";
      kdDebug(555) << "ln " << "-s " << installedPlugin << " " << QDir::homeDirPath() + "/.mozilla/plugins" << endl;
      process.start(KProcess::Block, KProcess::Stderr);
      process.clearArguments();
    }
    else
      kdWarning(555) << "Mozilla-Plugin not installed correctly!" << endl;
  }

  QStringList dirs = KGlobal::dirs()->findDirs("data", "kaffeine");
  QString dataPath;
  if ( dirs[0].left(5) != "/home" ) /* global data path */
     dataPath = dirs[0];  
    else
     dataPath = dirs[1];
  QString localServiceDir = QDir::homeDirPath() + "/.kde/share/services";

  if ( useMMSHelper->isChecked() )
  {
    process << "cp" << dataPath + "mms.protocol" << localServiceDir;
    kdDebug(555) << "cp " << dataPath + "mms.protocol" << " " << localServiceDir << endl;
    process.start(KProcess::Block, KProcess::Stderr);
    process.clearArguments();
  }

  if ( useRTSPHelper->isChecked() )
  {
    process << "cp" << dataPath + "rtsp.protocol" << localServiceDir;
    kdDebug(555) << "cp " << dataPath + "rtsp.protocol" << " " << localServiceDir << endl;
    process.start(KProcess::Block, KProcess::Stderr);
    process.clearArguments();
  }

  dirs = KGlobal::dirs()->findDirs("apps", "Multimedia");
  if ( dirs[0].left(5) != "/home" ) /* global applnk path */
     dataPath = dirs[0];   
   else
     dataPath = dirs[1];

  if ( createDesktopIcon->isChecked() )
  {
    process << "cp" << dataPath + "kaffeine.desktop" << QDir::homeDirPath() + "/Desktop";
    kdDebug(555) << "cp " << dataPath + "kaffeine.desktop" << " " << QDir::homeDirPath() + "/Desktop" << endl;
    process.start(KProcess::Block, KProcess::Stderr);
    process.clearArguments();
  }

  
  delete this;
}


void WizardDialog::reject()
{
  delete this;
}
  




