/***************************************************************************
                           urllistview.h 
                             -------------------
    begin                : Mon Apr 28 2003
    revision             : $Revision: 1.8 $
    last modified        : $Date: 2004/02/20 16:44:02 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J. Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef URLLISTVIEW_H
#define URLLISTVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <klistview.h>
#include <kpopupmenu.h>

#include <qwidget.h>
#include <qdragobject.h>

#include "playlistitem.h"


class UrlListView : public KListView
{
   Q_OBJECT
public: 
 UrlListView(QWidget *parent=0, const char *name=0);
 ~UrlListView();

 void SetCleared(bool);   
 bool GetCleared() const; /* was the playlist cleared or should we save it? */

public slots:
  virtual void clear();  /* reimplement slot */

signals:
  void signalPlayItem(QListViewItem* );  /* play selected in context menu */
  void signalCut();
  void signalCopy();
  void signalPaste();
  
private slots:
  void slotShowContextMenu(QListViewItem*, const QPoint&, int);
  void slotCurrentChanged(QListViewItem *);
  void slotAddSubtitle();
  void slotShowInfo();
  void slotEditTitle();
  void slotPlayItem();
  void slotClicked( QListViewItem*, const QPoint&, int );
  
protected:
  virtual bool acceptDrag(QDropEvent* event) const;
  virtual void resizeEvent(QResizeEvent*);
  virtual QDragObject* dragObject();

private:
  
  void enableSubEntry();
  void disableSubEntry();

  bool listCleared;
  int column2Width;  /* width of the second column */

  PlaylistItem *itemOfContextMenu;
  KPopupMenu* contextMenu;
  
};

#endif
