/***************************************************************************
                          playlistitem  -  A self-displayable item for 
			                   kaffeine's playlist
                             -------------------
    begin                : Mon Feb 16 2004
    revision             : $Revision: 1.1 $
    last modified        : $Date: 2004/02/20 16:40:11 $ by $Author: juergenk $    
    copyright            : (C) 2004 by Giorgos Gousios
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef PLAYLISTITEM_H
#define PLAYLISTITEM_H
 
#include <klistview.h>

#include <qstringlist.h> 
 
class PlaylistItem : public KListViewItem
{

public:
   PlaylistItem(KListViewItem *parent, KListViewItem *after,  QString url, QString mime, QString title, QString length, QString info,  QStringList subtitles);
   PlaylistItem(KListView *list, KListViewItem *after, QString url, QString mime, QString title,  QString length, QString info,  QStringList subtitles);
   virtual ~PlaylistItem();

   QString url();
   QString mime();
   QString title();
   QString length();
   QString info();
   QStringList subtitles();
   
   void setUrl(QString);
   void setMime(QString);
   void setTitle(QString);
   void setLength(QString);
   void setInfo(QString);
   void setSubtitles(QStringList);
   void addSubtitle(QString);
   
private:
   QStringList m_subtitles;
};


#endif



