/***************************************************************************
                          playlistitem  -  A self-displayable item for
			                   kaffeine's playlist
                             -------------------
    begin                : Mon Feb 16 2004
    revision             : $Revision: 1.1 $
    last modified        : $Date: 2004/02/20 16:39:30 $ by $Author: juergenk $        
    copyright            : (C) 2004 by Giorgos Gousios
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "playlistitem.h"
 
PlaylistItem::PlaylistItem(KListViewItem *parent, KListViewItem * after,  QString url, QString mime, QString title, QString length, QString info, QStringList subtitles) :
KListViewItem(parent, after, mime, title, length, info, url)
{
   setSubtitles(subtitles);
}

PlaylistItem::PlaylistItem(KListView *list, KListViewItem * after,  QString url, QString mime, QString title, QString length,QString info, QStringList subtitles) :
KListViewItem(list, after, mime, title, length, info, url)
{
   setSubtitles(subtitles);
}

PlaylistItem::~PlaylistItem() {}

QString PlaylistItem::url()
{
  return this->text(4);
}
QString PlaylistItem::mime()
{
  return this->text(0);
}
QString PlaylistItem::title()
{
  return this->text(1);
}
QString PlaylistItem::length()
{
  return this->text(2);
}
QString PlaylistItem::info()
{
  return this->text(3);
}
QStringList PlaylistItem::subtitles()
{
  return m_subtitles;
}
   
void PlaylistItem::setUrl(QString url)
{
  this->setText(4, url);
}
void PlaylistItem::setMime(QString mime)
{
  this->setText(0, mime);
}
void PlaylistItem::setTitle(QString title)
{
  this->setText(1, title);
}
void PlaylistItem::setLength(QString length)
{
  this->setText(2, length);
}
void PlaylistItem::setInfo(QString info)
{
  this->setText(3, info);
}
void PlaylistItem::setSubtitles(QStringList subs)
{
  m_subtitles = subs;
}

void PlaylistItem::addSubtitle(QString sub)
{
  m_subtitles.append(sub);
}



