/***************************************************************************
                          myslider.cpp
                          by Giorgos Gousios <gousiosg@cs.man.ac.uk>
                             -------------------
    begin                : Wed Feb 4 2004
    revision             : $Revision: 1.3 $
    last modified        : $Date: 2004/04/22 10:01:50 $ by $Author: juergenk $
    copyright            : (C) 2004 by Juergen  Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h> 

#include "myslider.h"
#include "myslider.moc"



MySlider::MySlider(Qt::Orientation o, QWidget *parent, const char* name) : QSlider(o, parent, name)
{
    userChange = false;
    connect(this, SIGNAL(sliderPressed()), this ,SLOT(slotSliderPressed()));
    connect(this, SIGNAL(sliderReleased()), this, SLOT(slotSliderReleased()));
    m_parent = parent;
    installEventFilter(this);
}

MySlider::MySlider(Qt::Orientation o, QObject* parent, QWidget *wparent, const char *name) : QSlider(o, wparent, name)
{
    userChange = false;
    connect(this, SIGNAL(sliderPressed()), this ,SLOT(slotSliderPressed()));
    connect(this, SIGNAL(sliderReleased()), this, SLOT(slotSliderReleased()));
    m_parent = parent;
    installEventFilter(this);
}

MySlider::~MySlider() {}

QObject * 
MySlider::parent()
{
   return this->m_parent;
}

void MySlider::SetValue(int val, bool changePosition) 
{  
   if(!userChange)
     setValue(val);
   if(changePosition){
     setValue(val);
     emit sliderMoved(val);
   }
} 
   
void MySlider::slotSliderPressed()
{   
   userChange = true;
   disconnect (this, SIGNAL(sliderMoved(int)),this->parent(),0);
}
   
void MySlider::slotSliderReleased()
{
   connect(this, SIGNAL(sliderMoved(int)), this->parent(), SIGNAL(signalChangePosition(int)));
   emit sliderMoved(this->value());
   userChange = false;
}

void MySlider::wheelEvent( QWheelEvent* e )
{
  float offset = log10( QABS(e->delta()) ) / 0.002;
  int newVal = 0;
  if (e->delta()>0)
     newVal = value() + int(offset);
  else
     newVal = value() - int(offset);

  SetValue( newVal, true );
  e->accept();
}

bool MySlider::eventFilter( QObject *obj, QEvent *ev )
{
  if( obj == this && (ev->type() == QEvent::MouseButtonPress ||
                      ev->type() == QEvent::MouseButtonDblClick) )
  {
     QMouseEvent *e = (QMouseEvent *)ev;
     QRect r = sliderRect();
     
     if( r.contains( e->pos() ) || e->button() != LeftButton )
        return FALSE;
     
     int range = maxValue() - minValue();
     int pos = (orientation() == Horizontal) ? e->pos().x() : e->pos().y();
     int maxpos = (orientation() == Horizontal) ? width() : height();
     int value = pos * range / maxpos + minValue();
     
     SetValue( value, true );
     return TRUE;  
  }
  else
  {
     return FALSE;
  }
}
