/***************************************************************************
                          filterdialog.h  - config dialog for postprocessing filters
                             -------------------
    begin                : Mon Dez 8 2003
    revision             : $Revision: 1.3 $
    last modified        : $Date: 2004/04/13 10:52:48 $ by $Author: juergenk $   
    copyright            : (C) 2003-2004 by Juergen  Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILTERDIALOG_H
#define FILTERDIALOG_H


#include <kdialogbase.h>
#include <kcombobox.h>

#include <qwidget.h>
#include <qvbox.h>
#include <qstringlist.h>

/**
  *@author Juergen  Kofler
  */

class FilterDialog : public KDialogBase
{
   Q_OBJECT
public: 
  FilterDialog(const QStringList& filters, QWidget *parent=0, const char *name=0);
  ~FilterDialog();

signals:
  void signalCreateFilter( const QString& name, QWidget* parent );
  void signalRemoveAll();
  void signalUseFilters( bool );
  
private slots:
  void slotAddClicked() { emit signalCreateFilter( filterCombo->currentText(), filterPage ); }
  void slotUseFilters( bool on );

private:
  KComboBox* filterCombo;      
  QVBox* filterPage;
  KPushButton* addButton;
  KPushButton* removeButton;  
  
};

#endif
