/***************************************************************************
                           controlpanel.h
                             -------------------
    begin                : Don Apr 17 2003
    revision             : $Revision: 1.11 $
    last modified        : $Date: 2004/03/14 13:14:51 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J. Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTROLPANEL_H
#define CONTROLPANEL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kpushbutton.h>
#include <kcombobox.h>

#include <dcopobject.h>

#include <qwidget.h>
#include <qslider.h>
#include <qvbox.h>
#include <qpixmap.h>

#include "myslider.h"


class ControlPanel : public QWidget, public DCOPObject
{
   Q_OBJECT
   K_DCOP
   
  friend class KMP;
   
 public: 
  ControlPanel(QWidget *parent=0, const char *name=0);
  ~ControlPanel();

  
  void setVolume(int vol);  
  void ResetControlPanel();  /* ready */
  void SetPlaying();         /* set xine is playing */
  bool GetPlaying() const;
  void SetRecording();

 /*** DCOP Interface ***/ 
 k_dcop:
  void posPlus() { slotPosPlus(); }
  void posMinus() { slotPosMinus(); }
  void volUp() { volSlider->subtractStep(); }
  void volDown() { volSlider->addStep(); }
  int  getPos() { return posSlider->value(); }
  void setPos(int pos) { emit signalChangePosition(pos); }  /* 0..65535 */
  int  getVol() { return -volSlider->value(); }
  void setVol(int vol) { setVolume(-vol); }  /* 0..100 */
  QString getTimeStr() { return timeButton->text(); }
  
 signals:
  void signalPlay();
  void signalSaveStreamAs();
  void signalPlayNext();
  void signalPlayPrevious();
  void signalPauseOn();
  void signalPauseOff();
  void signalStop();
  void signalVolumeChanged(int);
  void signalSetAudioChannel(int);
  void signalSetSubtitleChannel(int);
  void signalChangePosition(int);
  void signalTogglePlayMode();
  void signalPlayList();

 public slots:
 /* get new channel info */
  void slotNewChannels(const QStringList& audio, const QStringList& subtitles, int currentAudio, int currentSub);
 /* get current position in stream */ 
  void slotNewPosition(int pos, const QString& time);
 /* get file-specific subtitles*/
 void slotNewSubtitles(QStringList subs, QString currentSub);
   
 private slots:
  void slotPlayPause();
  void slotStop();
  void slotNext();
  void slotPrev();
  void slotPosPlus();
  void slotPosMinus();

 private:
  KPushButton* playPausePB;

  KPushButton* nextPB;
  KPushButton* prevPB;
  KPushButton* stopPB;
  KPushButton* timeButton;
  KPushButton* playListPB;
  KPushButton* recordPB;
 
  MySlider* posSlider;
  QSlider* volSlider;

  KComboBox* audioChannelCB;
  KComboBox* subtitleCB;
  QStringList subs;
  
  QPixmap playPixmap;
  QPixmap pausePixmap;

  bool isPlaying;
  bool isPlayButton;
 
};


class MyHBox : public QHBox
{
  Q_OBJECT

  public:
   MyHBox( QWidget *parent=0, const char *name=0 ) : QHBox( parent, name ) {}
   ~MyHBox() {}

  signals:
    void signalChangePosition(int);
};  

#endif
