#include <k3dsdk/path.h>

#include <iostream>
#include <sstream>
#include <stdexcept>

class quoted_string
{
public:
	quoted_string(const std::string& String) :
		string(String)
	{
	}

	friend std::ostream& operator<<(std::ostream& Stream, const quoted_string& String)
	{
		Stream << "[" << String.string << "]";
		return Stream;
	}

private:
	const std::string string;
};

void test(const std::string& Path, const std::string Results)
{
	k3d::filesystem::path path = k3d::filesystem::native_path(Path);

	std::ostringstream buffer;
	buffer << quoted_string(path.string());

	std::cout << buffer.str() << std::endl;
	if(buffer.str() != Results)
		throw std::runtime_error("results don't match");
}

int main(int argc, char* argv[])
{
	try
	{
		test("/", "[/]");
		test("foo", "[foo]");
		test("foo/bar", "[foo/bar]");
		test("/foo/bar", "[/foo/bar]");
		test(".", "[.]");
		test("..", "[..]");
		test("../foo", "[../foo]");
		test("c:", "[c:]");
		test("c:\\", "[c:/]");
		test("c:..", "[c:..]");
		test("c:foo", "[c:foo]");
		test("c:\\foo", "[c:/foo]");
		test("\\\\shr", "[//shr]");
		test("\\\\shr\\", "[//shr/]");
		test("\\\\shr\\foo", "[//shr/foo]");
		test("prn:", "[prn:]");

		return 0;
	}
	catch(std::exception& e)
	{
		std::cerr << "exception: " << e.what() << std::endl;
		return 1;
	}
}

