#include <k3dsdk/socket.h>
#include <k3dsdk/system.h>

#include <iostream>

int main(int argc, char* argv[])
{
	const int port = 10000;
	
	try
	{
		k3d::socket::endpoint connection = k3d::socket::connect("localhost", port);
		std::cerr << "connected to server on port " << port << std::endl;
		
		while(true)
		{
			connection.write("test\n");
			k3d::system::sleep(0.5);
		}
	}
	catch(k3d::socket::closed& e)
	{
		std::cerr << "server disconnected" << std::endl;
	}
	catch(std::exception& e)
	{
		std::cerr << e.what() << std::endl;	
	}
}

