#ifndef K3DSDK_MESH_SINK_H
#define K3DSDK_MESH_SINK_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "data.h"
#include "i18n.h"
#include "imesh_sink.h"
#include "mesh.h"

namespace k3d
{

template<typename base_t>
class mesh_sink :
	public base_t,
	public imesh_sink
{
public:
	mesh_sink(idocument& Document) :
		base_t(Document),
		m_input_mesh(init_owner(*this) + init_name("input_mesh") + init_label(_("Input Mesh")) + init_description(_("Input mesh")) + init_value<mesh*>(0))
	{
	}

	iproperty& mesh_sink_input()
	{
		return m_input_mesh;
	}

protected:
	k3d_data(mesh*, immutable_name, change_signal, no_undo, local_storage, no_constraint, read_only_property, no_serialization) m_input_mesh;
};

} // namespace k3d

#endif // !K3DSDK_MESH_SINK_H


