#ifndef K3DSDK_FSTREAM_H
#define K3DSDK_FSTREAM_H

// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include <boost/filesystem/fstream.hpp>

namespace boost { namespace filesystem { class path; } }

namespace k3d
{

namespace filesystem
{

template< class charT, class traits = std::char_traits<charT> >
class basic_ifstream : public boost::filesystem::basic_ifstream<charT,traits>
{
public:
	basic_ifstream()
	{
	}
	
	explicit basic_ifstream(const boost::filesystem::path& file_ph, std::ios_base::openmode mode = std::ios_base::in | std::ios_base::binary) :
		boost::filesystem::basic_ifstream<charT,traits>(file_ph, mode)
	{
	}
	
	virtual ~basic_ifstream()
	{
	}
	
	void open(const boost::filesystem::path& file_ph, std::ios_base::openmode mode = std::ios_base::in | std::ios_base::binary)
	{
		boost::filesystem::basic_ifstream<charT,traits>::open(file_ph, mode);
	}
};

typedef basic_ifstream<char> ifstream;
// typedef basic_ifstream<wchar_t> wifstream; // Why do you want to use this?  It isn't portable, and you should be using UTF-8!

template < class charT, class traits = std::char_traits<charT> >
class basic_ofstream : public boost::filesystem::basic_ofstream<charT,traits>
{
public:
	basic_ofstream()
	{
	}
	
	explicit basic_ofstream(const boost::filesystem::path& file_ph, std::ios_base::openmode mode = std::ios_base::out | std::ios_base::binary) :
		boost::filesystem::basic_ofstream<charT,traits>(file_ph, mode)
	{
	}
	
	virtual ~basic_ofstream()
	{
	}
	
	void open(const boost::filesystem::path & file_ph, std::ios_base::openmode mode = std::ios_base::out | std::ios_base::binary)
	{
		boost::filesystem::basic_ofstream<charT,traits>::open(file_ph, mode);
	}
};

typedef basic_ofstream<char> ofstream;
// typedef basic_ofstream<wchar_t> wofstream; // Why do you want to use this?  It isn't portable, and you should be using UTF-8!

template < class charT, class traits = std::char_traits<charT> >
class basic_fstream : public boost::filesystem::basic_fstream<charT,traits>
{
public:
	basic_fstream()
	{
	}
	
	explicit basic_fstream(const boost::filesystem::path& file_ph, std::ios_base::openmode mode = std::ios_base::in|std::ios_base::out | std::ios_base::binary) :
		boost::filesystem::basic_fstream<charT,traits>(file_ph, mode)
	{
	}
	
	virtual ~basic_fstream()
	{
	}

	void open(const boost::filesystem::path& file_ph, std::ios_base::openmode mode = std::ios_base::in|std::ios_base::out | std::ios_base::binary)
	{
		boost::filesystem::basic_fstream<charT,traits>::open(file_ph, mode);
	}
};

typedef basic_fstream<char> fstream;
// typedef basic_fstream<wchar_t> wfstream; // Why do you want to use this?  It isn't portable, and you should be using UTF-8!

} // namespace filesystem

} // namespace k3d

#endif // K3DSDK_FSTREAM_H


