import re
import fileinput
import sys
import os.path

data = re.compile("AM_INIT_AUTOMAKE\(([^,]*),([^)]*)\)")
f=open('configure.ac')
conf = f.read()
match = data.search(conf,1)
package = match.group(1)
version = match.group(2)

if(not os.path.exists("./k3dsdk/version.h") or
		os.path.getmtime("./k3dsdk/version.h") < os.path.getmtime("./configure.ac")):

	v=open("./k3dsdk/version.h", "w")

	for line in fileinput.input(["./k3dsdk/version.h.in"]):
		line = re.sub("@PACKAGE@", package, line)
		line = re.sub("@VERSION@", version, line)
		line = re.sub("@host@", "i686-pc-mingw32", line)
		v.write(line)

if(not os.path.exists("./distribution/win32_setup.nsi") or
		os.path.getmtime("./distribution/win32_setup.nsi") < os.path.getmtime("./configure.ac")):
	v=open("./distribution/win32_setup.nsi", "w")

	for line in fileinput.input(["./distribution/win32_setup.nsi.in"]):
		line = re.sub("@VERSION@", version, line)
		v.write(line)

if(not os.path.exists("./distribution/win32_all_in_one_setup.nsi") or
		os.path.getmtime("./distribution/win32_all_in_one_setup.nsi") < os.path.getmtime("./configure.ac")):
	v=open("./distribution/win32_all_in_one_setup.nsi", "w")

	for line in fileinput.input(["./distribution/win32_all_in_one_setup.nsi.in"]):
		line = re.sub("@VERSION@", version, line)
		v.write(line)
