
########################################################
# K3D_CHECK_COMPILERS

AC_DEFUN([K3D_CHECK_COMPILERS], [

AC_ARG_WITH(gcc-2-96, [  --with-gcc-2-96         build using gcc 2.96, which may generate unusable executables [[no]]],[],[withval=no])
if test x"$withval" = xyes; then
	k3d_use_gcc_2_96="yes"
fi

AC_MSG_CHECKING([for problematic compiler versions])

if $CXX --version | grep "2\.96" >/dev/null 2>/dev/null; then

	AC_MSG_RESULT([found gcc 2.96])

	if test "$k3d_use_gcc_2_96" = yes; then
		AC_MSG_WARN([

Building K-3D with gcc 2.96.  This is an unofficial release of gcc that has been known to
produce unusable K-3D executables.  If you have problems, our recommendation is that you
switch to gcc 2.95 or gcc 3.0 or above.
])
	else
		AC_MSG_ERROR([

It appears that you're using gcc 2.96.  This is an unofficial release of gcc that has been known to produce
unusable K-3D executables.  It's possible that an incremental upgrade to gcc 2.96 may have fixed whatever
problems existed in the past, so you may re-run configure with the --with-gcc-2-96 option to override this test.
If you do so and continue to have problems, our recommendation is that you switch to gcc 2.95 or gcc 3.0 or above.
])
	fi

else

	AC_MSG_RESULT([none found])

fi

])

########################################################
# K3D_COMPILER_FLAGS

AC_DEFUN([K3D_COMPILER_FLAGS], [
AC_SUBST(K3D_CFLAGS)
AC_SUBST(K3D_CPPFLAGS)
AC_SUBST(K3D_CXXFLAGS)

K3D_CFLAGS="-Wall"
K3D_CPPFLAGS="-I\$(top_srcdir) -I\$(top_builddir)"
K3D_CXXFLAGS="-Wall -Wno-ctor-dtor-privacy"

])

