#python

import k3d

doc = k3d.Document
doc.start_change_set()
try:
	cone = doc.new_object("Cone")
	cone.name = "IceCreamCone"

	cone.add_user_property("bool", "bool", "Boolean", "Boolean user property")
	cone.add_user_property("color", "color", "Color", "Color user property")
	cone.add_user_property("double", "double", "Double", "Double user property")	
	cone.add_user_property("matrix4", "matrix4", "Matrix4", "Matrix4 user property")	
	cone.add_user_property("string", "string", "String", "String user property")	
	cone.add_user_property("vector3", "vector3", "Vector3", "Vector3 user property")

	cone.add_ri_attribute("integer", "render", "ri_attribute_integer", "RenderMan Integer", "RenderMan Integer Attribute")
	cone.add_ri_attribute("real", "render", "ri_attribute_real", "RenderMan Real", "RenderMan Real Attribute")
	cone.add_ri_attribute("string", "render", "ri_attribute_string", "RenderMan String", "RenderMan String Attribute")
	cone.add_ri_attribute("point", "render", "ri_attribute_point", "RenderMan Point", "RenderMan Point Attribute")
	cone.add_ri_attribute("vector", "render2", "ri_attribute_vector", "RenderMan Vector", "RenderMan Vector Attribute")
	cone.add_ri_attribute("color", "render2", "ri_attribute_color", "RenderMan Color", "RenderMan Color Attribute")
	cone.add_ri_attribute("hpoint", "render2", "ri_attribute_hpoint", "RenderMan HPoint", "RenderMan HPoint Attribute")
	cone.add_ri_attribute("matrix", "render2", "ri_attribute_matrix", "RenderMan Matrix", "RenderMan Matrix Attribute")

	cone.string = "Howdy, World!"

	doc.finish_change_set("User Property Sample")

except:
	doc.cancel_change_set()
	raise

