#python

import k3d

doc = k3d.Document
doc.start_change_set()
try:
	material = doc.new_object("RenderManMaterial")
	material.name = "Curve Material"
	material.color = (1, 1, 1)

	frozen_mesh = doc.new_object("FrozenMesh")
	frozen_mesh.name = "Linear Curve"

	mesh = frozen_mesh.new_mesh()

	points = ((0, 5, 5), (5, 5, -5), (-5, -5, 0), (5, -5, 0))
	for position in points:
		mesh.new_point(position)

	group = mesh.new_linear_curve_group()
	group.material = material

	curve = group.new_curve()
	for i in range(4):
		curve.control_points[i] = mesh.points[i]

#	group.constant_data.set_color("Cs", (0, 0, 1))
#	curve.uniform_data.set_color("Cs", (1, 1, 0))

	curve.varying_data[0].set_color("Cs", (1, 1, 0))
	curve.varying_data[0].set_real("width", 3)
	curve.varying_data[1].set_color("Cs", (0, 1, 0))
	curve.varying_data[1].set_real("width", 1)
	curve.varying_data[2].set_color("Cs", (0, 0, 1))
	curve.varying_data[2].set_real("width", 3)
	curve.varying_data[3].set_color("Cs", (1, 0, 0))
	curve.varying_data[3].set_real("width", 1)

	mesh_instance = doc.new_object("MeshInstance")
	mesh_instance.name = "Linear Curve Instance"
	doc.set_dependency(mesh_instance.get_property("input_mesh"), frozen_mesh.get_property("output_mesh"))

	doc.finish_change_set("Create Linear Curve")

except:
	doc.cancel_change_set()
	raise

