#python

import k3d

def PrintProperties(Node, Level):

	if Node.is_property_collection:
		for property in Node.properties:

			indentation = ""
			for j in range(Level):
				indentation += "  "

			record = indentation + "property: " + property.name + " - " + property.description + " - " + property.type + " - " + str(property.value)
			
			if property.is_writable:
				record += " (read/write)"
			else:
				record += " (read-only)"

			print record

def PrintCommandNode(Node, Level):

	for j in range(Level):
		print " ",

	print "node: " + Node.command_node_name

	PrintProperties(Node, Level + 1)

	for child in Node.children:
		PrintCommandNode(child, Level + 1)

# Main
PrintCommandNode(k3d.Application, 0)



